/*
 * Decompiled with CFR 0.152.
 */
package chess4j.board;

public enum CastlingRights {
    WHITE_KINGSIDE(0, "K"),
    WHITE_QUEENSIDE(1, "Q"),
    BLACK_KINGSIDE(2, "k"),
    BLACK_QUEENSIDE(3, "q");

    private int _value;
    private String _label;

    private CastlingRights(int value, String label) {
        this._value = value;
        this._label = label;
    }

    public boolean equals(CastlingRights cr) {
        if (cr == null) {
            return false;
        }
        return cr.getValue() == this._value;
    }

    public int getValue() {
        return this._value;
    }

    public String getLabel() {
        return this._label;
    }

    public static CastlingRights getCastlingRights(int value) {
        CastlingRights[] castlingRightsArray = CastlingRights.values();
        int n = castlingRightsArray.length;
        int n2 = 0;
        while (n2 < n) {
            CastlingRights cr = castlingRightsArray[n2];
            if (cr.getValue() == value) {
                return cr;
            }
            ++n2;
        }
        throw new IllegalArgumentException("CastlingRights value not found: " + value);
    }
}

