/*
 * Decompiled with CFR 0.152.
 */
package chess4j.board;

import chess4j.App;
import chess4j.Color;
import chess4j.board.Board;
import chess4j.board.BoardVerifier;
import chess4j.board.CastlingRights;
import chess4j.board.File;
import chess4j.board.Rank;
import chess4j.board.Square;
import chess4j.board.Undo;
import chess4j.hash.Zobrist;
import chess4j.moves.Move;
import chess4j.pieces.Bishop;
import chess4j.pieces.King;
import chess4j.pieces.Knight;
import chess4j.pieces.Pawn;
import chess4j.pieces.Piece;
import chess4j.pieces.Queen;
import chess4j.pieces.Rook;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BoardImpl
implements Board {
    private List<Undo> _undoStack = new ArrayList<Undo>();
    private Map<Square, Piece> _pieceMap = new HashMap<Square, Piece>();
    private Map<Piece, List<Square>> _squaresMap = new HashMap<Piece, List<Square>>();
    private Set<CastlingRights> _castlingRights = new HashSet<CastlingRights>();
    private Color _playerToMove;
    private Square _epSquare;
    private int _fiftyCounter;

    public BoardImpl() {
        this._squaresMap.put(Rook.BLACK_ROOK, new ArrayList());
        this._squaresMap.put(Rook.WHITE_ROOK, new ArrayList());
        this._squaresMap.put(Knight.BLACK_KNIGHT, new ArrayList());
        this._squaresMap.put(Knight.WHITE_KNIGHT, new ArrayList());
        this._squaresMap.put(Bishop.BLACK_BISHOP, new ArrayList());
        this._squaresMap.put(Bishop.WHITE_BISHOP, new ArrayList());
        this._squaresMap.put(Queen.BLACK_QUEEN, new ArrayList());
        this._squaresMap.put(Queen.WHITE_QUEEN, new ArrayList());
        this._squaresMap.put(Pawn.BLACK_PAWN, new ArrayList());
        this._squaresMap.put(Pawn.WHITE_PAWN, new ArrayList());
        this._squaresMap.put(King.BLACK_KING, new ArrayList());
        this._squaresMap.put(King.WHITE_KING, new ArrayList());
        this.resetBoard();
    }

    @Override
    public void addCastlingRight(CastlingRights castlingRight) {
        this._castlingRights.add(castlingRight);
    }

    @Override
    public void addPiece(Piece p, Square s) {
        this._pieceMap.put(s, p);
        if (p != null) {
            this._squaresMap.get(p).add(s);
        }
    }

    private void applyKingSpecialCases(Move m) {
        if (this._playerToMove.isWhite()) {
            this._castlingRights.remove((Object)CastlingRights.WHITE_KINGSIDE);
            this._castlingRights.remove((Object)CastlingRights.WHITE_QUEENSIDE);
            if (m.from().equals(Square.valueOf(File.FILE_E, Rank.RANK_1))) {
                if (m.to().equals(Square.valueOf(File.FILE_G, Rank.RANK_1))) {
                    this._fiftyCounter = 0;
                    this.movePiece(Square.valueOf(File.FILE_H, Rank.RANK_1), Square.valueOf(File.FILE_F, Rank.RANK_1));
                } else if (m.to().equals(Square.valueOf(File.FILE_C, Rank.RANK_1))) {
                    this._fiftyCounter = 0;
                    this.movePiece(Square.valueOf(File.FILE_A, Rank.RANK_1), Square.valueOf(File.FILE_D, Rank.RANK_1));
                }
            }
        } else {
            this._castlingRights.remove((Object)CastlingRights.BLACK_KINGSIDE);
            this._castlingRights.remove((Object)CastlingRights.BLACK_QUEENSIDE);
            if (m.from().equals(Square.valueOf(File.FILE_E, Rank.RANK_8))) {
                if (m.to().equals(Square.valueOf(File.FILE_G, Rank.RANK_8))) {
                    this._fiftyCounter = 0;
                    this.movePiece(Square.valueOf(File.FILE_H, Rank.RANK_8), Square.valueOf(File.FILE_F, Rank.RANK_8));
                } else if (m.to().equals(Square.valueOf(File.FILE_C, Rank.RANK_8))) {
                    this._fiftyCounter = 0;
                    this.movePiece(Square.valueOf(File.FILE_A, Rank.RANK_8), Square.valueOf(File.FILE_D, Rank.RANK_8));
                }
            }
        }
    }

    @Override
    public void applyMove(Move m) {
        assert (BoardVerifier.verifyBoard(this));
        this._undoStack.add(new Undo(m, this._fiftyCounter, this._castlingRights, this._epSquare));
        if (m.captured() == null) {
            ++this._fiftyCounter;
        } else {
            this._fiftyCounter = 0;
            if (m.to().equals(Square.valueOf(File.FILE_H, Rank.RANK_1))) {
                this._castlingRights.remove((Object)CastlingRights.WHITE_KINGSIDE);
            } else if (m.to().equals(Square.valueOf(File.FILE_A, Rank.RANK_1))) {
                this._castlingRights.remove((Object)CastlingRights.WHITE_QUEENSIDE);
            }
            if (m.to().equals(Square.valueOf(File.FILE_H, Rank.RANK_8))) {
                this._castlingRights.remove((Object)CastlingRights.BLACK_KINGSIDE);
            } else if (m.to().equals(Square.valueOf(File.FILE_A, Rank.RANK_8))) {
                this._castlingRights.remove((Object)CastlingRights.BLACK_QUEENSIDE);
            }
        }
        Piece p = this.removePiece(m.from());
        if (p instanceof Pawn) {
            this.applyPawnMove(p, m);
        } else {
            if (m.captured() != null) {
                this.removePiece(m.to());
            }
            this.addPiece(p, m.to());
            this._epSquare = null;
            if (p instanceof King) {
                this.applyKingSpecialCases(m);
            } else if (p instanceof Rook) {
                this.applyRookSpecialCases(m);
            }
        }
        this.swapPlayer();
        assert (BoardVerifier.verifyBoard(this));
    }

    private void applyPawnMove(Piece p, Move m) {
        this._fiftyCounter = 0;
        if (p.isWhite()) {
            if (m.from().rank().equals(Rank.RANK_2) && m.to().rank().equals(Rank.RANK_4)) {
                this.addPiece(p, m.to());
                this._epSquare = Square.valueOf(m.to().file(), m.to().rank().south());
            } else if (m.to().equals(this._epSquare)) {
                this.removePiece(Square.valueOf(this._epSquare.file(), this._epSquare.rank().south()));
                this.addPiece(p, m.to());
                this._epSquare = null;
            } else if (m.to().rank().equals(Rank.RANK_8)) {
                this.removePiece(m.to());
                this.addPiece(m.promotion(), m.to());
                this._epSquare = null;
            } else {
                this.removePiece(m.to());
                this.addPiece(p, m.to());
                this._epSquare = null;
            }
        } else if (m.from().rank().equals(Rank.RANK_7) && m.to().rank().equals(Rank.RANK_5)) {
            this.addPiece(p, m.to());
            this._epSquare = Square.valueOf(m.to().file(), m.to().rank().north());
        } else if (m.to().equals(this._epSquare)) {
            this.removePiece(Square.valueOf(this._epSquare.file(), this._epSquare.rank().north()));
            this.addPiece(p, m.to());
            this._epSquare = null;
        } else if (m.to().rank().equals(Rank.RANK_1)) {
            this.removePiece(m.to());
            this.addPiece(m.promotion(), m.to());
            this._epSquare = null;
        } else {
            this.removePiece(m.to());
            this.addPiece(p, m.to());
            this._epSquare = null;
        }
    }

    private void applyRookSpecialCases(Move m) {
        if (this._playerToMove.isWhite()) {
            if (m.from().equals(Square.valueOf(File.FILE_H, Rank.RANK_1))) {
                this._fiftyCounter = 0;
                this._castlingRights.remove((Object)CastlingRights.WHITE_KINGSIDE);
            } else if (m.from().equals(Square.valueOf(File.FILE_A, Rank.RANK_1))) {
                this._fiftyCounter = 0;
                this._castlingRights.remove((Object)CastlingRights.WHITE_QUEENSIDE);
            }
        } else if (m.from().equals(Square.valueOf(File.FILE_H, Rank.RANK_8))) {
            this._fiftyCounter = 0;
            this._castlingRights.remove((Object)CastlingRights.BLACK_KINGSIDE);
        } else if (m.from().equals(Square.valueOf(File.FILE_A, Rank.RANK_8))) {
            this._fiftyCounter = 0;
            this._castlingRights.remove((Object)CastlingRights.BLACK_QUEENSIDE);
        }
    }

    private boolean blackCanCastleKingSide() {
        Color opponent = Color.swap(this._playerToMove);
        return this.hasCastlingRight(CastlingRights.BLACK_KINGSIDE) && this.isEmpty(Square.valueOf(File.FILE_F, Rank.RANK_8)) && this.isEmpty(Square.valueOf(File.FILE_G, Rank.RANK_8)) && !App.getAttack().attacked(this, Square.valueOf(File.FILE_E, Rank.RANK_8), opponent) && !App.getAttack().attacked(this, Square.valueOf(File.FILE_F, Rank.RANK_8), opponent);
    }

    private boolean blackCanCastleQueenSide() {
        Color opponent = Color.swap(this._playerToMove);
        return this.hasCastlingRight(CastlingRights.BLACK_QUEENSIDE) && this.isEmpty(Square.valueOf(File.FILE_D, Rank.RANK_8)) && this.isEmpty(Square.valueOf(File.FILE_C, Rank.RANK_8)) && this.isEmpty(Square.valueOf(File.FILE_B, Rank.RANK_8)) && !App.getAttack().attacked(this, Square.valueOf(File.FILE_E, Rank.RANK_8), opponent) && !App.getAttack().attacked(this, Square.valueOf(File.FILE_D, Rank.RANK_8), opponent);
    }

    @Override
    public boolean canCastle(CastlingRights cr) {
        if (cr.equals(CastlingRights.WHITE_KINGSIDE)) {
            return this.whiteCanCastleKingSide();
        }
        if (cr.equals(CastlingRights.WHITE_QUEENSIDE)) {
            return this.whiteCanCastleQueenSide();
        }
        if (cr.equals(CastlingRights.BLACK_KINGSIDE)) {
            return this.blackCanCastleKingSide();
        }
        return this.blackCanCastleQueenSide();
    }

    @Override
    public void clearBoard() {
        List<Square> squares = Square.allSquares();
        for (Square sq : squares) {
            Piece p = this.getPiece(sq);
            if (p == null) continue;
            this.removePiece(sq);
        }
        this._epSquare = null;
        this._castlingRights.clear();
        this._fiftyCounter = 0;
        this._undoStack.clear();
    }

    @Override
    public synchronized Board deepCopy() {
        BoardImpl b = new BoardImpl();
        b._undoStack.clear();
        b._undoStack.addAll(this._undoStack);
        b._pieceMap.clear();
        for (Square sq : this._pieceMap.keySet()) {
            b._pieceMap.put(sq, this._pieceMap.get(sq));
        }
        b._squaresMap.clear();
        for (Piece p : this._squaresMap.keySet()) {
            ArrayList squares = new ArrayList(this._squaresMap.get(p));
            b._squaresMap.put(p, squares);
        }
        b._castlingRights.clear();
        b._castlingRights.addAll(this._castlingRights);
        b._playerToMove = this._playerToMove;
        b._epSquare = this._epSquare;
        b._fiftyCounter = this._fiftyCounter;
        return b;
    }

    @Override
    public List<Square> getSquares(Piece p) {
        return Collections.unmodifiableList(this._squaresMap.get(p));
    }

    private Square getBlackKingSquare() {
        List<Square> kingSquares = this._squaresMap.get(King.BLACK_KING);
        assert (kingSquares.size() == 1);
        return kingSquares.get(0);
    }

    @Override
    public Square getEPSquare() {
        return this._epSquare;
    }

    @Override
    public int getFiftyCounter() {
        return this._fiftyCounter;
    }

    @Override
    public Square getKingSquare(Color player) {
        return player.isWhite() ? this.getWhiteKingSquare() : this.getBlackKingSquare();
    }

    @Override
    public int getMoveCounter() {
        return this._undoStack.size();
    }

    @Override
    public Piece getPiece(Square square) {
        return this._pieceMap.get(square);
    }

    @Override
    public Color getPlayerToMove() {
        return this._playerToMove;
    }

    private Square getWhiteKingSquare() {
        List<Square> kingSquares = this._squaresMap.get(King.WHITE_KING);
        assert (kingSquares.size() == 1);
        return kingSquares.get(0);
    }

    private boolean hasCastlingRight(CastlingRights cr) {
        return this._castlingRights.contains((Object)cr);
    }

    @Override
    public boolean isEmpty(Square square) {
        return this._pieceMap.get(square) == null;
    }

    @Override
    public boolean isOpponentInCheck() {
        return App.getAttack().attacked(this, this.getKingSquare(Color.swap(this._playerToMove)), this._playerToMove);
    }

    @Override
    public boolean isPlayerInCheck() {
        return App.getAttack().attacked(this, this.getKingSquare(this._playerToMove), Color.swap(this._playerToMove));
    }

    @Override
    public void movePiece(Square from, Square to) {
        if (from.equals(to)) {
            return;
        }
        this.addPiece(this.getPiece(from), to);
        this.removePiece(from);
    }

    private Piece removePiece(Square s) {
        Piece p = this.getPiece(s);
        if (p == null) {
            return null;
        }
        this._pieceMap.remove(s);
        this._squaresMap.get(p).remove(s);
        return p;
    }

    @Override
    public void resetBoard() {
        this._undoStack.clear();
        this._pieceMap.clear();
        this._squaresMap.get(Rook.WHITE_ROOK).clear();
        this._squaresMap.get(Rook.BLACK_ROOK).clear();
        this._squaresMap.get(Knight.WHITE_KNIGHT).clear();
        this._squaresMap.get(Knight.BLACK_KNIGHT).clear();
        this._squaresMap.get(Bishop.WHITE_BISHOP).clear();
        this._squaresMap.get(Bishop.BLACK_BISHOP).clear();
        this._squaresMap.get(Queen.WHITE_QUEEN).clear();
        this._squaresMap.get(Queen.BLACK_QUEEN).clear();
        this._squaresMap.get(Pawn.WHITE_PAWN).clear();
        this._squaresMap.get(Pawn.BLACK_PAWN).clear();
        this._squaresMap.get(King.WHITE_KING).clear();
        this._squaresMap.get(King.BLACK_KING).clear();
        this.addPiece(Rook.BLACK_ROOK, Square.valueOf(File.FILE_A, Rank.RANK_8));
        this.addPiece(Knight.BLACK_KNIGHT, Square.valueOf(File.FILE_B, Rank.RANK_8));
        this.addPiece(Bishop.BLACK_BISHOP, Square.valueOf(File.FILE_C, Rank.RANK_8));
        this.addPiece(Queen.BLACK_QUEEN, Square.valueOf(File.FILE_D, Rank.RANK_8));
        this.addPiece(King.BLACK_KING, Square.valueOf(File.FILE_E, Rank.RANK_8));
        this.addPiece(Bishop.BLACK_BISHOP, Square.valueOf(File.FILE_F, Rank.RANK_8));
        this.addPiece(Knight.BLACK_KNIGHT, Square.valueOf(File.FILE_G, Rank.RANK_8));
        this.addPiece(Rook.BLACK_ROOK, Square.valueOf(File.FILE_H, Rank.RANK_8));
        List<Square> squares = Square.rankSquares(Rank.RANK_7);
        for (Square sq : squares) {
            this.addPiece(Pawn.BLACK_PAWN, sq);
        }
        squares = Square.rankSquares(Rank.RANK_2);
        for (Square sq : squares) {
            this.addPiece(Pawn.WHITE_PAWN, sq);
        }
        this.addPiece(Rook.WHITE_ROOK, Square.valueOf(File.FILE_A, Rank.RANK_1));
        this.addPiece(Knight.WHITE_KNIGHT, Square.valueOf(File.FILE_B, Rank.RANK_1));
        this.addPiece(Bishop.WHITE_BISHOP, Square.valueOf(File.FILE_C, Rank.RANK_1));
        this.addPiece(Queen.WHITE_QUEEN, Square.valueOf(File.FILE_D, Rank.RANK_1));
        this.addPiece(King.WHITE_KING, Square.valueOf(File.FILE_E, Rank.RANK_1));
        this.addPiece(Bishop.WHITE_BISHOP, Square.valueOf(File.FILE_F, Rank.RANK_1));
        this.addPiece(Knight.WHITE_KNIGHT, Square.valueOf(File.FILE_G, Rank.RANK_1));
        this.addPiece(Rook.WHITE_ROOK, Square.valueOf(File.FILE_H, Rank.RANK_1));
        this._castlingRights.clear();
        this._castlingRights.addAll(EnumSet.allOf(CastlingRights.class));
        this._playerToMove = Color.WHITE;
        this._epSquare = null;
        this._fiftyCounter = 0;
    }

    @Override
    public void setEP(Square ep) {
        this._epSquare = ep;
    }

    @Override
    public void swapPlayer() {
        this._playerToMove = Color.swap(this._playerToMove);
    }

    private void undoCastle(Undo u, Piece p) {
        if (p.isWhite()) {
            if (u.getMove().from().equals(Square.valueOf(File.FILE_E, Rank.RANK_1))) {
                if (u.getMove().to().equals(Square.valueOf(File.FILE_G, Rank.RANK_1))) {
                    this.movePiece(Square.valueOf(File.FILE_F, Rank.RANK_1), Square.valueOf(File.FILE_H, Rank.RANK_1));
                } else if (u.getMove().to().equals(Square.valueOf(File.FILE_C, Rank.RANK_1))) {
                    this.movePiece(Square.valueOf(File.FILE_D, Rank.RANK_1), Square.valueOf(File.FILE_A, Rank.RANK_1));
                }
            }
        } else if (u.getMove().from().equals(Square.valueOf(File.FILE_E, Rank.RANK_8))) {
            if (u.getMove().to().equals(Square.valueOf(File.FILE_G, Rank.RANK_8))) {
                this.movePiece(Square.valueOf(File.FILE_F, Rank.RANK_8), Square.valueOf(File.FILE_H, Rank.RANK_8));
            } else if (u.getMove().to().equals(Square.valueOf(File.FILE_C, Rank.RANK_8))) {
                this.movePiece(Square.valueOf(File.FILE_D, Rank.RANK_8), Square.valueOf(File.FILE_A, Rank.RANK_8));
            }
        }
    }

    private void undoPawnMove(Undo u, Piece p) {
        if (p.isWhite()) {
            if (u.getMove().to().equals(this._epSquare)) {
                this.addPiece(u.getMove().captured(), Square.valueOf(this._epSquare.file(), this._epSquare.rank().south()));
                this.addPiece(p, u.getMove().from());
            } else {
                this.addPiece(u.getMove().captured(), u.getMove().to());
                this.addPiece(p, u.getMove().from());
            }
        } else if (u.getMove().to().equals(this._epSquare)) {
            this.addPiece(u.getMove().captured(), Square.valueOf(this._epSquare.file(), this._epSquare.rank().north()));
            this.addPiece(p, u.getMove().from());
        } else {
            this.addPiece(u.getMove().captured(), u.getMove().to());
            this.addPiece(p, u.getMove().from());
        }
    }

    private void undoPromotion(Undo u) {
        this.addPiece(u.getMove().captured(), u.getMove().to());
        this.addPiece(this._playerToMove.equals(Color.WHITE) ? Pawn.WHITE_PAWN : Pawn.BLACK_PAWN, u.getMove().from());
    }

    @Override
    public void undoLastMove() {
        assert (BoardVerifier.verifyBoard(this));
        int ind = this._undoStack.size() - 1;
        Undo u = this._undoStack.remove(ind);
        this.swapPlayer();
        this._epSquare = u.getEpSquare();
        this._fiftyCounter = u.getFiftyCounter();
        this._castlingRights.clear();
        this._castlingRights.addAll(u.getCastlingRights());
        Piece p = this.removePiece(u.getMove().to());
        if (u.getMove().promotion() != null) {
            this.undoPromotion(u);
        } else if (p instanceof Pawn) {
            this.undoPawnMove(u, p);
        } else {
            if (p instanceof King) {
                this.undoCastle(u, p);
            }
            this.addPiece(u.getMove().captured(), u.getMove().to());
            this.addPiece(p, u.getMove().from());
        }
        assert (BoardVerifier.verifyBoard(this));
    }

    private boolean whiteCanCastleKingSide() {
        Color opponent = Color.swap(this._playerToMove);
        return this.hasCastlingRight(CastlingRights.WHITE_KINGSIDE) && this.isEmpty(Square.valueOf(File.FILE_F, Rank.RANK_1)) && this.isEmpty(Square.valueOf(File.FILE_G, Rank.RANK_1)) && !App.getAttack().attacked(this, Square.valueOf(File.FILE_E, Rank.RANK_1), opponent) && !App.getAttack().attacked(this, Square.valueOf(File.FILE_F, Rank.RANK_1), opponent);
    }

    private boolean whiteCanCastleQueenSide() {
        Color opponent = Color.swap(this._playerToMove);
        return this.hasCastlingRight(CastlingRights.WHITE_QUEENSIDE) && this.isEmpty(Square.valueOf(File.FILE_D, Rank.RANK_1)) && this.isEmpty(Square.valueOf(File.FILE_C, Rank.RANK_1)) && this.isEmpty(Square.valueOf(File.FILE_B, Rank.RANK_1)) && !App.getAttack().attacked(this, Square.valueOf(File.FILE_E, Rank.RANK_1), opponent) && !App.getAttack().attacked(this, Square.valueOf(File.FILE_D, Rank.RANK_1), opponent);
    }

    public int hashCode() {
        int h = 0;
        for (Square sq : Square.allSquares()) {
            Piece p = this.getPiece(sq);
            if (p == null) continue;
            h ^= Zobrist.getPieceKey(sq, p);
        }
        h ^= Zobrist.getPlayerKey(this.getPlayerToMove());
        Square ep = this.getEPSquare();
        if (ep != null) {
            h ^= Zobrist.getEnPassantKey(ep);
        }
        for (CastlingRights cr : this._castlingRights) {
            h ^= Zobrist.getCastlingKey(cr);
        }
        return h;
    }
}

