/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-François, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#include "timecontroler.h"

#include<iostream>
using namespace std;

void TimeControler::setSecondsPerMove(int seconds)
{
    mode=SECONDSPERMOVE;
    secondsPerMove=seconds;
}

void TimeControler::setClock(int movesPerTimeControl, int baseTime, int incrementTime)
{
    
   if(movesPerTimeControl == 0) movesPerTimeControl=39; //whole game  // was 80 - JA
     
    mode=CLOCK;
    this->movesPerTimeControl=movesPerTimeControl;
    this->baseTime=baseTime;
    this->incrementTime=incrementTime;
    movesLeft=movesPerTimeControl+1;
    timeLeft=this->baseTime;
}

void TimeControler::setTimeLeft(int centiSeconds)
{
    movesLeft--;
    
    if(movesLeft < 10) {
    timeLeft=centiSeconds/60;  // was 100 - JA
    if(movesLeft < 1) movesLeft=movesPerTimeControl;
    }else{
    if(movesLeft < 1) movesLeft=movesPerTimeControl;
    timeLeft=centiSeconds/40;  // was 100 - JA
    }
}

int TimeControler::getAllowedTime()
{
    switch(mode)
    {
        case SECONDSPERMOVE : return secondsPerMove; break;
        case CLOCK :
            cout<<"tl "<<timeLeft<<" ml "<<movesLeft<<" ic "<<incrementTime<<endl;
            return (timeLeft/movesLeft)+incrementTime; break;
        default : return 10;
    }
}
