/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-Franois, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#ifndef CASSANDRE_SEARCHER_H
#define CASSANDRE_SEARCHER_H 1

#include <ctime>
#include <vector>
#include "move.h"
#include "position.h"
#include "movegenerator.h"

#include "evaluator.h"
#include "alfevaluator.h"
#include "interface.h"
#include "searchelement.h"

/**
 * The Searcher class is an abstract class designed to represent all
 * tree-searching algorithms. If you want to try your own searching
 * algorithm (Minimax, AlphaBeta, PVS, Negascout...), you will have to
 * extend this class and implement your own <I>rootSearch</I> method. 
 * @author Jean-Francois Romang<jeff@proxone.net>
 */
class Searcher
{
    public:
        Searcher(Interface *i)
        {
            evaluator=new AlfEvaluator();
            moveGenerator=new MoveGenerator();
            post=true; //TODO: initialiser a false qd debug termine
            iface=i;
        }
        
        virtual ~Searcher()
        {
            delete evaluator;
            delete moveGenerator;
        }
        
        /** Launches a search at fixed depth. @return The best Move found during the search !*/
        Move rootSearch(Position *current, int depth);
        virtual void treeSearch(Position *current, std::vector<SearchElement> *elements, int depth)=0;
        Move IterativeRootSearchTime(Position *current, float time);
        Move IterativeRootSearch(Position *current, int depth);
        MoveGenerator* getMoveGenerator();
        void setPost(bool value);      
        int analysedPositions;
                
    protected:
        Interface *iface;
        Evaluator *evaluator;
        MoveGenerator *moveGenerator;
        bool post;
        const static int infinity=1000000;//=10000000;
        const static int mateValue=200000;
};

#endif
