/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-Franois, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#include <iostream>
#ifndef _MSC_VER
#include <algorithm>
#endif
#include "searcher.h"


MoveGenerator* Searcher::getMoveGenerator()
{
    return moveGenerator;
}

/** If true, the searcher will post informations (nodes per second, etc...) while searching. */
void Searcher::setPost(bool value)
{
    post=value;
}

Move Searcher::IterativeRootSearchTime(Position *current, float time)
{
    clock_t startTime=clock();
    //while(((clock()-startTime)/(double)CLOCKS_PER_SEC)<(time/12))
    //{
    //    depth++;
    //    m=rootSearch(current,depth);
    //}
    
    std::vector<Move>* nextMoves=moveGenerator->generateMoves(current);
    std::vector<SearchElement> *elements=new std::vector<SearchElement>;
    std::vector<SearchElement>::iterator iterE;
    
    std::vector<Move>::iterator iter;
    for(iter=nextMoves->begin(); iter<nextMoves->end(); iter++)
    {
        SearchElement e((*iter),0);
        elements->insert(elements->end(),e);
    }
    delete nextMoves;
    
    for(int i=1;(((clock()-startTime)/(double)CLOCKS_PER_SEC)<(time/8)) || (i<4);i++)
    {
        std::sort(elements->begin(),elements->end(),SDescendingSearchElementSort());
        treeSearch(current,elements,i);
        if(analysedPositions==0) break;
    }

    //return the bestMove;
    iterE=elements->begin();
    while(iterE<elements->end())
    {
        Move bestMove=(*iterE).move;
        current->doMove(bestMove);
        if(moveGenerator->isLegal(current))
        {
            current->undoMove(bestMove);
            delete elements;
            return bestMove;
        }
        current->undoMove(bestMove); //rajoute
        iterE++;
    }
    
    delete elements;
    std::cout<<"**cassandre mated**"<<std::endl;
    return 0;
}

Move Searcher::IterativeRootSearch(Position *current, int depth)
{
    std::vector<Move>* nextMoves=moveGenerator->generateMoves(current);
    std::vector<SearchElement> *elements=new std::vector<SearchElement>;
    std::vector<SearchElement>::iterator iterE;
    
    std::vector<Move>::iterator iter;
    for(iter=nextMoves->begin(); iter<nextMoves->end(); iter++)
    {
        SearchElement e((*iter),0);
        elements->insert(elements->end(),e);
    }
    delete nextMoves;
    
    for(int i=1;i<=depth;i++)
    {
        std::sort(elements->begin(),elements->end(),SDescendingSearchElementSort());
        treeSearch(current,elements,i);
    }

    //return the bestMove;
    iterE=elements->begin();
    while(iterE<elements->end())
    {
        Move bestMove=(*iterE).move;
        current->doMove(bestMove);
        if(moveGenerator->isLegal(current))
        {
            current->undoMove(bestMove);
            delete elements;
            return bestMove;
        }
        iterE++;
    }
    
    delete elements;
    std::cout<<"**cassandre mated**"<<std::endl;
    return 0;
}

Move Searcher::rootSearch(Position *current, int depth)
{
    //CANMoveParser mp;

    std::vector<Move>* nextMoves=moveGenerator->generateMoves(current);
    std::vector<SearchElement> *elements=new std::vector<SearchElement>;
    
    std::vector<Move>::iterator iter;
    for(iter=nextMoves->begin(); iter<nextMoves->end(); iter++)
    {
        SearchElement e((*iter),0);
        elements->insert(elements->end(),e);
    }
    
    treeSearch(current,elements,depth);
    std::sort(elements->begin(),elements->end(),SDescendingSearchElementSort());
    
    /*
    std::vector<SearchElement>::iterator iterE;
    for(iterE=elements->begin(); iterE<elements->end(); iterE++)
    {
        char *move=mp.getStringFromMove((*iterE).move, current);
        
        std::cout<<move<<' '<<(*iterE).value<<std::endl;
        delete move;
    }*/
    
    Move bestMove=0;
    if(!elements->empty()) bestMove=(elements->begin())->move;
    
    delete elements;
    delete nextMoves;
    
    //return bestMove;
    
    if(bestMove.move!=0)
	current->doMove(bestMove);
    if(moveGenerator->isLegal(current)&&bestMove.move!=0){current->undoMove(bestMove); return bestMove;}
    else
    {
        current->undoMove(bestMove);
        std::cout<<"resign"<<std::endl;
    }
    return 0;
    
    //return(m);
}
