/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-Franois, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#ifndef CASSANDRE_SANMOVEPARSER_H
#define CASSANDRE_SANMOVEPARSER_H 1

#include <iostream>
#include "move.h"
#include "moveparser.h"
#include "movegenerator.h"

//Standard Algebraic Notation MoveParser
class SANMoveParser : public MoveParser
{
    public:
    	SANMoveParser() { mg = new MoveGenerator(); }
	virtual ~SANMoveParser() { delete(mg); }
        Move getMoveFromString(const char *moveString, Position *p);
        char* getStringFromMove(Move m, Position *p);
    private:
    	MoveGenerator * mg;
};

#endif
