/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-Franois, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#include "sanmoveparser.h"
#include "position.h"

#define SANDEBUG 0

using namespace std;

Move SANMoveParser::getMoveFromString(const char *moveString, Position *p)
{

	// TODO : echec, mat
	
	Move m=0;
	
	int i, trouve;
	char temp;
	
	int length = strlen( moveString );
	
	unsigned char player;
	unsigned char piece;
	unsigned char promotion;
	int from=0, to=0;
    	char from_t[3],to_t[3];
	
	
	//----- JOUEUR -----
	player = ( p->flags & playerMask );
	
	//----- ROQUE ----
	if ( moveString[0] == 'O' )
	{
		if ( player )
		{
			m.setBreaksWhiteKingCastle();
			m.setBreaksWhiteQueenCastle();
		}
		else
		{
			m.setBreaksBlackKingCastle();
			m.setBreaksBlackQueenCastle();
		}

		if ( length < 5 ) // petit roque
		{
			if ( player )
			{
				from = 59;
				to = 57;
			}
			else
			{
				from = 3;
				to = 1;
			}
		}
		else // grand roque
		{
			if ( player )
			{
				from = 59;
				to = 61;
			}
			else
			{
				from = 3;
				to = 5;
			}
		}
		
		if ( SANDEBUG )
		{
			cout << "roque\n";
			cout << "from=" << from << "\n";
			cout << "to=" << from << "\n";
		}

		m.setMovingPiece(p->pieceAt(from));

		return( m | (from<<6) | to);
	}
	
	//----- PIECE -----
	temp = moveString[0];
	
	if ( player )	// blancs
	{
		switch ( temp )
		{
			case 'R' : piece = W_ROOK; break;
			case 'N' : piece = W_KNIGHT; break;
			case 'B' : piece = W_BISHOP; break;
			case 'Q' : piece = W_QUEEN; break;
			case 'K' : piece = W_KING; break;
			default :  piece = W_PAWN; break;
		}
	}
	else
	{
		switch ( temp )
		{
			case 'R' : piece = B_ROOK; break;
			case 'N' : piece = B_KNIGHT; break;
			case 'B' : piece = B_BISHOP; break;
			case 'Q' : piece = B_QUEEN; break;
			case 'K' : piece = B_KING; break;
			default :  piece = B_PAWN;
		}
	}
	

	//----- CASE D'ARRIVEE -----
	i = length-1;
	trouve = 0;
	
	while ( i>=0 && !trouve )
	{
		if ( moveString[i]>='1' && moveString[i]<='8' )
			trouve = 1;
		else
			i--;
	}
	
	to_t[0]=moveString[i-1]; to_t[1]=moveString[i]; to_t[2]='\0';
	
	for( i=0 ; i<64 ; i++)
		if(!strcmp(to_t,squareName[i])) to=i;
	
		
	//----- PROMOTION -----
	promotion = 0;
	
	if ( piece == W_PAWN )
	{
		for ( i=0 ; i<length ; i++ )
		{
			if ( moveString[i] == 'R' )
				promotion = W_ROOK;
			else if ( moveString[i] == 'N' )
				promotion = W_KNIGHT;
			else if ( moveString[i] == 'B' )
				promotion = W_BISHOP;
			else if ( moveString[i] == 'Q' )
				promotion = W_QUEEN;
		}
	}
	else if ( piece == B_PAWN )
	{
		for ( i=0 ; i<length ; i++ )
		{
			if ( moveString[i] == 'R' )
				promotion = B_ROOK;
			else if ( moveString[i] == 'N' )
				promotion = B_KNIGHT;
			else if ( moveString[i] == 'B' )
				promotion = B_BISHOP;
			else if ( moveString[i] == 'Q' )
				promotion = B_QUEEN;
		}
	}
	


	
	//----- CASE DE DEPART -----
	std::vector<Move>* mouvements = mg->generateMoves(p);
	std::vector<Move>::iterator iter;
	int count = 0;
	
	for(iter=mouvements->begin(); iter<mouvements->end(); iter++)
	{	
		// si meme pice et meme case d'arrive
		if ( p->pieceAt( iter->from() )==piece && iter->to()==to )
		{
			strcpy( from_t, MoveParser::squareName[((*iter)>>6)&movementMask] );
			count++;
		}
	}
		
	if ( count != 1 )
	{
		count = 0;
		
		if ( piece==W_PAWN || piece==B_PAWN )
		{
		        for(iter=mouvements->begin(); iter<mouvements->end(); iter++)
		        {
				// si pion et meme case d'arrivee et meme colonne de dpart
				if ( p->pieceAt( iter->from() )== piece && iter->to()==to && ('h'-(iter->from())%8) == moveString[0] )
				{
					strcpy( from_t, MoveParser::squareName[iter->from()] );
					count++;
				}
			}
		}
		else
		{
		        for(iter=mouvements->begin(); iter<mouvements->end(); iter++)
		        {
				// si meme piece et meme case d'arrivee et meme colonne de dpart
				if ( p->pieceAt( iter->from() )== piece && iter->to()==to && ('h'-(iter->from())%8) == moveString[1] )
				{
					strcpy( from_t, MoveParser::squareName[iter->from()] );
					count++;
				}
			}
			
			if ( count > 1 )
			{
				from_t[0] = moveString[1];
				from_t[1] = moveString[2];
				from_t[2] = '\0';
			}
		}
	}
	
	
	//----- INITIALISATION DE MOVE -----
	
	// cases de depart et d'arrivee
	for( i=0 ; i<64 ; i++)
		if(!strcmp(from_t,squareName[i])) from=i;


	if ( SANDEBUG )
	{
		cout << "--- move from string ---\n";
		cout << "movestring=" << moveString << "\n"; 	
		cout << "player=" << (int)(player) << "\n";
		cout << "piece=" << (int)piece << "\n";
		cout << "from=" << from_t << " (" << from << ")\n";
		cout << "to=" << to_t << "(" << to << ")\n";
		cout << "promotion=" << (int)promotion << "\n";
		cout << "--- fin move from string ---\n";
	}

	// piece
	m.setMovingPiece(p->pieceAt(from));
	
	// capture
	if( ! p->empty(to) )
	{
		m.setCapture();
		switch(p->pieceAt(to))
		{
			case W_PAWN	: m.setCapturedPiece(W_PAWN); break;
			case W_KNIGHT	: m.setCapturedPiece(W_KNIGHT); break;
			case W_BISHOP	: m.setCapturedPiece(W_BISHOP); break;
			case W_ROOK	: m.setCapturedPiece(W_ROOK); break;
			case W_QUEEN	: m.setCapturedPiece(W_QUEEN); break;
			case W_KING	: m.setCapturedPiece(W_KING); break;
			case B_PAWN	: m.setCapturedPiece(B_PAWN); break;
			case B_KNIGHT	: m.setCapturedPiece(B_KNIGHT); break;
			case B_BISHOP	: m.setCapturedPiece(B_BISHOP); break;
			case B_ROOK	: m.setCapturedPiece(B_ROOK); break;
			case B_QUEEN	: m.setCapturedPiece(B_QUEEN); break;
			case B_KING	: m.setCapturedPiece(B_KING); break;
		}
            
		if(to==56 && (p->flags&whiteShortCastleMask)) m.setBreaksWhiteKingCastle();
		if(to==63 && (p->flags&whiteLongCastleMask)) m.setBreaksWhiteQueenCastle();
		if(to==0 && (p->flags&blackShortCastleMask)) m.setBreaksBlackKingCastle();
		if(to==7 && (p->flags&blackLongCastleMask)) m.setBreaksBlackQueenCastle();
	}
	
	// promotion
	if ( promotion )
	{
		m.setPromotion();	
		m.setPromotionPiece(promotion);
	}
	
	// roques
	if(m.getMovingPiece()==W_KING && (p->flags&whiteShortCastleMask)) m.setBreaksWhiteKingCastle();
	if(m.getMovingPiece()==W_KING && (p->flags&whiteLongCastleMask)) m.setBreaksWhiteQueenCastle();
	if(m.getMovingPiece()==B_KING && (p->flags&blackShortCastleMask)) m.setBreaksBlackKingCastle();
	if(m.getMovingPiece()==B_KING && (p->flags&blackLongCastleMask)) m.setBreaksBlackQueenCastle();
	if(from==56 && (p->flags&whiteShortCastleMask)) m.setBreaksWhiteKingCastle();
	if(from==63 && (p->flags&whiteLongCastleMask)) m.setBreaksWhiteQueenCastle();
	if(from==0 && (p->flags&blackShortCastleMask)) m.setBreaksBlackKingCastle();
	if(from==7 && (p->flags&blackLongCastleMask)) m.setBreaksBlackQueenCastle();

	return( m | (from<<6) | to);
}

char* SANMoveParser::getStringFromMove(Move m, Position *p)
{
	char* move = new char[6];
	char* temp = new char[2];
	
	// cases de dpart et d'arrive
	unsigned char from = m.from();
	unsigned char to = m.to();
	
	// pice qui bouge    
	unsigned char piece = p->pieceAt( from );
    
	// roque blanc
	if ( piece==W_KING && from==59 && ( to==57 || to==61 ) )
	{
		if ( to==57 )
			strcpy( move, "O-O" );
		else
			strcpy( move, "O-O-O" );
	}
	// roque noir
	else if ( piece==B_KING && from==3 && ( to==1 || to==5 ) )
	{
		if ( to==1 )
			strcpy( move, "O-O" );
		else
			strcpy( move, "O-O-O" );
	}
	// autres cas
	else
	{
		// pice
		switch( piece )
		{
			case W_KING:   strcpy(move,"K"); break;
			case W_QUEEN:  strcpy(move,"Q"); break;
			case W_ROOK:   strcpy(move,"R"); break;
			case W_BISHOP: strcpy(move,"B"); break;
			case W_KNIGHT: strcpy(move,"N"); break;
			case B_KING:   strcpy(move,"K"); break;
			case B_QUEEN:  strcpy(move,"Q"); break;
			case B_ROOK:   strcpy(move,"R"); break;
			case B_BISHOP: strcpy(move,"B"); break;
			case B_KNIGHT: strcpy(move,"N"); break;
			default:       strcpy(move, ""); break;
		}
		
		// discrimination si plusieurs possiblilits
		
		if ( piece != W_PAWN && piece != B_PAWN )
		{
			std::vector<Move>* mouvements = mg->generateMoves(p);
			std::vector<Move>::iterator iter;
			int count = 0;
	
		        for(iter=mouvements->begin(); iter<mouvements->end(); iter++)
		        {	
				// si meme pice et meme case d'arrive
				if ( p->pieceAt( iter->from() )==piece && iter->to()==to )
					count++;
			}

			// si plusieurs pices peuvent aller sur 'to'
			if ( count > 1 )
			{
				count = 0;
				
			        for(iter=mouvements->begin(); iter<mouvements->end(); iter++)
			        {
					// si meme pice et meme colonne de dpart
					if ( p->pieceAt( iter->from() )== piece && iter->to()==to && (iter->from())%8 == from%8 )
						count++;
				}
				
				if ( count > 1 )
				{
					strcat( move, MoveParser::squareName[(m>>6)&movementMask] );
				}
				else
				{
					sprintf( temp, "%c", 'h' - from%8 );
					strcat( move, temp );
				}
			}
		}
		
		// capture
		if ( m.isCapture() )
		{
			// prise par une pice
			if ( piece != W_PAWN && piece != B_PAWN )
				strcat( move, "x" );
			// prise par un pion
			else
			{
				sprintf( temp, "%c", 'h' - from%8 );
				strcat( move, temp );
				strcat( move, "x" );
			}
		}

		// case d'arrive
		strcat( move, MoveParser::squareName[m&movementMask] );
		
		if(m.isPromotion())
		{
			switch(m.promotionPiece())
			{
				case W_QUEEN:  strcat(move,"Q"); break;
				case W_ROOK:   strcat(move,"R"); break;
				case W_BISHOP: strcat(move,"B"); break;
				case W_KNIGHT: strcat(move,"N"); break;
				case B_QUEEN:  strcat(move,"Q"); break;
				case B_ROOK:   strcat(move,"R"); break;
				case B_BISHOP: strcat(move,"B"); break;
				case B_KNIGHT: strcat(move,"N"); break;
			}
		}
	}
	
	// echec
	bitboard attacks;

	if(p->flags&playerMask) // white plays 
	{
		p->doMove(m);
		attacks=mg->getAttacks(p,true);
		if( (p->b_occupied^p->b_pawn^p->b_knight^p->b_bishop^p->b_rook^p->b_queen) & attacks)
			strcat(move,"+" );
		p->undoMove(m);
	}
	else // black plays
	{
		p->doMove(m);
		attacks=mg->getAttacks(p,false);
		if( (p->w_occupied^p->w_pawn^p->w_knight^p->w_bishop^p->w_rook^p->w_queen) & attacks)
			strcat(move,"+" );
		p->undoMove(m);
	}

	// TODO : mat
	
	return move;
}
