/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-François, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#ifndef CASSANDRE_OPENINGBOOK_H
#define CASSANDRE_OPENINGBOOK_H 1

#include <iostream>
#include <cstdlib>
#include "move.h"
#include "sanmoveparser.h"
#include "position.h"
#include "internalbookdata.h"
#include "interface.h"

class OpeningBook
{
    public:
    	OpeningBook(Interface *i)
        { 
            smp = new SANMoveParser();
            currentPosition = new Position("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1");
            strcpy( currentMoves, "" );
            strcpy( nextMove, "" );
            totalMoves=0;
            iface=i;
        }
	virtual ~OpeningBook() { delete(smp); delete(currentPosition); }
        void reset();
        void doMove(Move m);
        bool hasMove();
        Move getMove();
    
    public:
        int totalMoves;
    	char currentMoves[1024];
	char nextMove[10];
	int possibleMovesCount;
	int possibleMoves[4096];
	SANMoveParser* smp;
	Position* currentPosition;
        Interface *iface;
};

#endif

