/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-François, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/



#include "openingbook.h"

#define OBDEBUG 0

using namespace std;

void OpeningBook::reset()
{	
	currentPosition->set("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1");
	strcpy( currentMoves, "" );
	strcpy( nextMove, "" );
        totalMoves=0;
}



void OpeningBook::doMove(Move m)
{	
	char* temp = new char[10];
	temp = smp->getStringFromMove( m, currentPosition );
	
	if ( strlen(currentMoves) )
		strcat( currentMoves, " ");
	
	strcat( currentMoves, temp );
	
	if ( OBDEBUG )
	{
		cout << "move=[" << temp << "]\n";
		cout << "currentMoves=[" << currentMoves << "]\n";
	}
	
	currentPosition->doMove(m);
        totalMoves++;
}



bool OpeningBook::hasMove()
{
        if(totalMoves>=14) return false;
        
	//cout << "--- OPENING BOOK ---\n\n";
	//cout << "currentMoves=[" << currentMoves << "]\n\n";
	possibleMovesCount = 0;
	
	char *temp = new char[1];
	int i,r;

	unsigned char player = ( currentPosition->flags & playerMask );

	
	if ( player ) // blanc
	{
		// on compte le nombre de parties correspondantes
		if ( strlen(currentMoves) )
		{
			for ( i=0 ; i<WBSIZE ; i++ )
			{
				if ( !strncmp( bookWhite[i], currentMoves, strlen(currentMoves) ) )
				{
					possibleMoves[possibleMovesCount] = i;
					possibleMovesCount++;
				}
			}
		}
		else
		{
			possibleMovesCount = WBSIZE;
		}
		
		//cout << possibleMovesCount << " parties correspondantes\n\n";
		
		// si aucune partie correspondante : on sort
		if ( possibleMovesCount == 0 )
		{
			cout << "--------------------\n";	
			return false;
		}
			
		// sinon on en prend une au hasard
		if ( strlen(currentMoves) )
			r = possibleMoves[rand()%possibleMovesCount];
		else
			r = rand()%possibleMovesCount;
		
		//cout << "Variante choisie : [" << bookWhite[r] << "]\n\n";
		iface->displayPV(bookWhite[r]);
                
		strcpy( nextMove, "" );
		
		// on prend le coup suivant
		if ( strlen(currentMoves) )
		{
			for ( i=strlen(currentMoves)+1 ; bookWhite[r][i] != ' ' && bookWhite[r][i] != '\0' ; i++ )
			{
				sprintf( temp, "%c", bookWhite[r][i] );
				strcat(nextMove, temp );
			}
		}
		else
		{
			for ( i=strlen(currentMoves) ; bookWhite[r][i] != ' ' && bookWhite[r][i] != '\0' ; i++ )
			{
				sprintf( temp, "%c", bookWhite[r][i] );
				strcat(nextMove, temp );
			}
		}
		
		//cout << "Prochain coup [" << nextMove << "]\n\n";
		//cout << "--------------------\n";
	}
	else	// noir
	{
		// on compte le nombre de parties correspondantes
		for ( i=0 ; i<BBSIZE ; i++ )
		{
			if ( !strncmp( bookBlack[i], currentMoves, strlen(currentMoves) ) )
			{
				possibleMoves[possibleMovesCount] = i;
				possibleMovesCount++;
			}
		}
		
		//cout << possibleMovesCount << " parties correspondantes\n\n";
		
		// si aucune partie correspondante : on sort
		if ( possibleMovesCount == 0 )
		{
			//cout << "--------------------\n";
			return false;
		}
			
		// sinon on en prend une au hasard
		r = possibleMoves[rand()%possibleMovesCount];
		
		//cout << "Variante choisie : [" << bookBlack[r] << "]\n\n";
                iface->displayPV(bookBlack[r]);
		
		strcpy( nextMove, "" );
		
		// on prend le coup suivant
		for ( i=strlen(currentMoves)+1 ; bookBlack[r][i] != ' ' && bookBlack[r][i] != '\0' ; i++ )
		{
			sprintf( temp, "%c", bookBlack[r][i] );
			strcat(nextMove, temp );
		}
		
		//cout << "Prochain coup [" << nextMove << "]\n\n";
		//cout << "--------------------\n";
	}
        
	if ( !strlen ( nextMove ) )
		return false;
		
	return true;
}

Move OpeningBook::getMove()
{
	return smp->getMoveFromString(nextMove, currentPosition);
}
