/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-Franois, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#ifndef CASSANDRE_MOVEPARSER_H
#define CASSANDRE_MOVEPARSER_H 1

#include <iostream>
#include "move.h"
#include "position.h"

class MoveParser
{
    public:
        virtual Move getMoveFromString(const char *moveString, Position *p)=0;
        virtual char* getStringFromMove(Move m, Position *p)=0;
        
    protected:
        const static char squareName[64][3];
};

#endif
