/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-Fran?ois, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#include <iostream>
#include <cstring>
#include <string>
#include "engine.h"

using namespace std;

int             CDECL
                main(int argc, char *argv[])
{
    
    int i;
    setbuf(stdout, NULL);
    setbuf(stdin, NULL);
    setvbuf(stdout, NULL, _IONBF, 0);
    setvbuf(stdin, NULL, _IONBF, 0);   
    
    Engine engine;
    string command; 
    char * buffer = new char[16384];
    
    
    for (i = 1; i < argc; i++) {
             
         if (strcmp(argv[i], "-book") == 0) {
            useInternalBook=true;
            i++;
        }
        }
    
	
    cout<<"Cassandre Chess Engine, V"<<engine.version<<endl;
    cout<<"Copyright (C) 2003 under the terms of the GNU General Public License"<<endl;
    cout<<"Authors : Jean-Francois Romang <jromang@users.sourceforge.net>"<<endl;
    cout<<"          Raphael Grundrich   <raphaelg@users.sourceforge.net>"<<endl;
    cout<<"          Thomas Adolph        <tadolph@users.sourceforge.net>"<<endl;
    cout<<"Website : http://cassandre.sourceforge.net"<<endl;
    cout.setf(ios::unitbuf);
    
    while(true)
    {
        std::getline(cin, command);
	strcpy(buffer, command.c_str());
	engine.iface->processCommand(buffer);
    }

    cout<<endl<<"Cassandre exited"<<endl;
    return 0;
}
