/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-François, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#include <iostream>
#include <cstring>
#include "engine.h"
#include "searcher.h"
#include "move.h"
#include "movegenerator.h"
#include "alphabetanegamaxsearcher.h"
#include "interface.h"

#include <stdlib.h>

#ifdef _MSC_VER
#include <windows.h>
#endif


using namespace std;

void Interface::displayTimeNPS(double timeInSeconds, int nps)
{
    switch(mode)
    {
        case UCI :
            cout<<"info time "<<(int)(timeInSeconds*1000)<<" nps "<<nps<<endl;
        break;
        default : 
            std::cout<<"Search time: "<<timeInSeconds<<" Speed: "<<nps<<" nodes/s."<<std::endl;
        break;
    }
}

void Interface::displayThinking(int depth, int score, int time, int nodes, char *pv)
{
    switch(mode)
    {
        case XBOARD :
            printf("%i %i %i %i %s\n", depth, score, time, nodes, pv);
            break;
            
        case UCI :       
       cout<<std::dec<<"info depth "<<depth<<" score cp "<<score<<" time "<<time*10<<" nodes "<<nodes<<" pv "<<pv<<endl;
          
            break;
        
        default : break;
    }
}

void Interface::displayPV(char *pv)
{
    switch(mode)
    {
        case UCI :
            cout<<"info pv "<<pv<<endl;
        break;
        default : break;
    }
}

void Interface::processCommand(char *commandLine)
{
    char *command=strtok (commandLine," ");
    Searcher *searcher;
    char *param;
    
    if(command==NULL) return;
    
    switch(mode)
    {
        case XBOARD :
            if(!strcmp(command,"xboard"))
            {
                switchXBoard();
            }
            if(!strcmp(command,"uci"))
            {
                switchUCI();
            }
            if(!strcmp(command,"quit"))
            {
                #ifdef _MSC_VER
                ExitProcess(0);
                #else
                exit(0);
                #endif
            }
            if(!strcmp(command,"benchmark"))
            {
                engine->benchmark();
            }
	    if(!strcmp(command,"show"))
            {
                engine->currentPosition->displayChessboard();
            }
            if(!strcmp(command,"showmoves"))
            {
                engine->showMoves();
            }
            if(!strcmp(command,"protover"))
            {	
                cout<<"feature setboard=1"<<endl;
                cout<<"feature analyze=1"<<endl;
                cout<<"feature usermove=1"<<endl;
                cout<<"feature time=1"<<endl; 
                cout<<"feature draw=0"<<endl; 
                cout<<"feature sigint=0"<<endl;
                cout<<"feature sigterm=0"<<endl; 
                cout<<"feature myname=\"Cassandre "<<engine->version<<"\""<<endl; 
                cout<<"feature colors=0"<<endl;
                cout<<"feature reuse=0"<<endl;
                cout<<"feature done=1"<<endl;
            }
            if(!strcmp(command,"usermove"))
            {
                char *param=strtok (NULL," ");
                cout<<"user has moved:"<<param<<endl;
                if(engine->opponentMove(param))
                {
                    if(!forceMode)
                    {
                        int seconds=engine->timeControler.getAllowedTime();
                        cout<<"Searching during "<<seconds<<" seconds."<<endl;
                        char *move=engine->play(seconds);
                        cout<<"move "<<move<<endl; //on envoie le mvt a xboard
                        delete move;
                    }
                }
                else cout<<"Illegal move: "<<param<<endl;
            }
            
               if(!strcmp(command,"setboard"))
            {
                char *param=strtok (NULL," ");
                engine->setBoard(param);
            }
            
             if(!strcmp(command,"analyze"))
            {
                int seconds=engine->timeControler.getAllowedTime();
                useInternalBook=false;
                cout<<"Searching during "<<seconds<<" seconds."<<endl;
                char *move=engine->play(seconds);
                cout<<"move "<<move<<endl;
                delete move;
            }
            
            if(!strcmp(command,"exit"))
            {}
             
              if(!strcmp(command,"."))
            {}       
            
            if(!strcmp(command,"go"))
            {
                forceMode=false;
                int seconds=engine->timeControler.getAllowedTime();
                cout<<"Searching during "<<seconds<<" seconds."<<endl;
                char *move=engine->play(seconds);
                cout<<"move "<<move<<endl;
                delete move;
            }
            if(!strcmp(command,"accepted"))
            {
            }
            if(!strcmp(command,"post"))
            {
                engine->setPost(true);
            }
            if(!strcmp(command,"nopost"))
            {
                engine->setPost(false);
            }
            if(!strcmp(command,"bench"))
            {
                //benchmark();
            }
            if(!strcmp(command,"new"))
            {
                engine->stop();
                engine->setBoard("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1");
                engine->reset();
            }
            if(!strcmp(command,"force"))
            {
                forceMode=true;
                engine->stop();
            }
            if(!strcmp(command,"level"))
            {
                char minutes[5],seconds[5];
            
                int mps,base,inc;
                unsigned int i,j;
                char *param=strtok (NULL," ");
                mps=atoi(param);
                param=strtok (NULL," ");
                
                //parsing to detect ':' (ex 0:30)
                for(i=0;(i<strlen(param))&&(param[i]!=':');i++)
                    minutes[i]=param[i];
                minutes[++i]='\0';
                j=0;
                seconds[j]='\0';
                for(;i<strlen(param);i++)
                {
                    seconds[j++]=param[i];
                    seconds[j]='\0';
                }                
                base=atoi(minutes)*60;
                if(strlen(seconds)!=0)
                    base+=atoi(seconds);

                param=strtok (NULL," ");
                inc=atoi(param);
                engine->timeControler.setClock(mps,base,inc);
            }
            if(!strcmp(command,"st"))
            {
                engine->timeControler.setSecondsPerMove(atoi(strtok (NULL," ")));
            }
            if(!strcmp(command,"time"))
            {
                engine->timeControler.setTimeLeft(atoi(strtok (NULL," ")));
            }

        
            break;
        case UCI :
            if(!strcmp(command,"xboard"))
            {
                switchXBoard();
            }
            if(!strcmp(command,"benchmark"))
            {
                engine->benchmark();
            }
	    if(!strcmp(command,"show"))
            {
                engine->currentPosition->displayChessboard();
            }
            if(!strcmp(command,"uci"))
            {
                switchUCI();
            }
            if(!strcmp(command,"debug"))
            {
                ;
            }
            if(!strcmp(command,"isready"))
            {
                cout<<"readyok"<<endl;
            }
            if(!strcmp(command,"setoption"))
            {
                char *param=strtok (NULL," "); //skip 'name'
                param=strtok (NULL," ");
                
                if(!strcasecmp(param,"useInternalOpeningBook"))
                {
                    char *value=strtok (NULL," ");//skip 'value'
                    value=strtok (NULL," ");
                    if(!strcasecmp(value,"false")) useInternalBook=false;
                    else useInternalBook=true;
                }
                
            }
            if(!strcmp(command,"position"))
            {
                char *param=strtok (NULL," ");
                
                if(!strcmp(param,"startpos"))
                {
                    engine->setBoard("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1");
                    strtok (NULL," "); //skip 'moves'
                }
                else if (strcmp(param,"moves"))
                {
                    engine->setBoard(param);
                    strtok (NULL," "); //skip 'moves'
                }
                
                //resets the book if necessary
                if(engine->isInStartPosition()) engine->reset();
                
                while((param=strtok (NULL," ")) != NULL)
                    engine->opponentMove(param);
            }
            if(!strcmp(command,"go"))
            {
                char *move=engine->play(10);
                cout<<"bestmove "<<move<<endl;
                delete move;
            }
            if(!strcmp(command,"stop"))
            {
                ;
            }
            if(!strcmp(command,"ponderhit"))
            {
                ;
            }
            if(!strcmp(command,"quit"))
            {
                #ifdef _MSC_VER
                ExitProcess(0);
                #else
                exit(0);
                #endif
            }
            
            break;
        case CONSOLE :
            if(!strcmp(command,"xboard"))
            {
                switchXBoard();
            }
            if(!strcmp(command,"uci"))
            {
                switchUCI();
            }
            break;
        default:
            break;
    }
}

void Interface::switchXBoard()
{
    mode=XBOARD;
    forceMode=false;
    cout<<"feature done=0"<<endl;
}

void Interface::switchUCI()
{
    mode=UCI;
    cout<<"id name Cassandre"<<endl;
    cout<<"id author Jean-Francois Romang, Raphael Grundrich, Thomas Adolph"<<endl;
    cout<<"option name useInternalOpeningBook type check default false"<<endl;
    cout<<"uciok"<<endl;
}

void Interface::switchConsole()
{
    mode=CONSOLE;
}

