/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-Franois, Adoplh Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project relised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info:
     jeff@proxone.net
*/

#ifndef CASSANDRE_HASHTABLE_H
#define CASSANDRE_HASHTABLE_H 1

#include <iostream>
#include "bitboardtoolkit.h"
#include "move.h"
#include "hashtableelement.h"
#include "position.h"

class HashTable {

  public:

     HashTableElement *hash_table;
     //int long taille_table;

     bitboard ZobristKey();

     //key for the position
     bitboard getZKey(Position *,bool );
     
     int ProbeHash(int depth, int alpha, int beta,Position *,Move *,bool);
     void RecordHash(int depth, int val, int hashf, Position *,Move *,bool);
     int getHashValue(Position *,bool );
     
     HashTable() {
       //taille_table = 1024 * 1024 ;
       //hash_table=new HashTableElement[taille_table];
         hash_table=new HashTableElement[HASHSIZE];
     }

};

#endif
