/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-Franois, Adoplh Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project relised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info:
     jeff@proxone.net
*/

#include "hashtable.h"


bitboard HashTable::getZKey(Position *p,bool side)
{
    bitboard zkey = 0;
    
    for(unsigned char i = 0; i<64; i++)
    {
      int piece = (int)(p->pieceAt(i));

      if (piece>6)
        zkey=zkey^BitboardToolkit::zobrist[piece-6][1][i];
      else
	zkey=zkey^BitboardToolkit::zobrist[piece][0][i];
    }
    
    //If Black play
    if (!side) zkey = zkey^BitboardToolkit::zobristColor;

    return zkey;
}

int HashTable::ProbeHash(int depth, int alpha, int beta,Position *p,Move *bestMove,bool side)
{

    bitboard zkey = getZKey(p,side);
    HashTableElement *phashe = &(hash_table[zkey % (HASHSIZE-1)]);
    int valUNKNOWN = -1;

    if (phashe->key == zkey ) {
	if (phashe->depth >= depth) {
            if (phashe->flags == hashfEXACT) {
	   //std::cout << "On retrouve une valeur exacte !!!clef = " << zkey << "phashvalue = "  << phashe->value << std::endl ;
                //return phashe->value;
		return hashfEXACT;
	    }
            if ((phashe->flags == hashfALPHA))// && (phashe->value <= alpha))
                //return alpha;
		return hashfALPHA;

            if ((phashe->flags == hashfBETA))// && (phashe->value >= beta))
                //return beta;
		return hashfBETA;
        }
	//RememberBestMove();
	*bestMove =  phashe->best;
    }
    return valUNKNOWN;
}

int HashTable::getHashValue(Position *p,bool side)
{
	HashTableElement *phashe = &(hash_table[getZKey(p,side) % (HASHSIZE-1)]);
		return phashe->value;

}

void HashTable::RecordHash(int depth, int val, int hashf, Position *p,Move *bestMove,bool side)
{
   //std::cout << "On Enregistre une valeur !!! clef = " << getZKey(p,side) << "phashvalue = "  << val << std::endl ;

    bitboard zkey = getZKey(p,side);
    
    HashTableElement *phashe = &(hash_table[zkey % (HASHSIZE-1)]);

    phashe->key = zkey;

    phashe->best = *bestMove;

    phashe->value = val;

    phashe->flags = hashf;

    phashe->depth = depth;
}
