/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-Fran?ois, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#ifndef CASSANDRE_ENGINE_H
#define CASSANDRE_ENGINE_H 1

#include <vector>
#include "position.h"
#include "searcher.h"
#include "alphabetanegamaxsearcher.h"
#include "moveparser.h"
#include "canmoveparser.h"
#include "sanmoveparser.h"
#include "interface.h"
#include "openingbook.h"
#include "timecontroler.h"

#ifdef _MSC_VER
#define inline __inline
int             strcasecmp(const char *s1, const char *s2);
#endif

#define CDECL

static bool useInternalBook = false;

//extern class Interface;

/**
 * This is the central class of our chess engine :) !
 */
class Engine
{
    friend class Interface;
    
    public:
        static const char* version;
        Interface *iface;
     //   bool useInternalBook;
    
        Engine()
        {
            currentPosition=new Position("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1");
            moveParser=new CANMoveParser();
            iface=new Interface(this);
         //   useInternalBook=true;
            book=new OpeningBook(iface);
            //searcher=new AlphaBetaSearcher(iface);
            searcher=new AlphaBetaNegamaxSearcher(iface);
        }
        
        ~Engine()
        {
            //TODO :: delete moveParser
            delete currentPosition;
            delete searcher;
            delete iface;
            delete book;
        }
        
        void start();
        void stop();
        bool opponentMove(char *move);
        void forceMove();
        void reset();
        void setColor(bool color);
        void setDepth(int d);
        void setBoard(char *board);
        char* play(float seconds);
        void setPondering(bool pondering);
        void setPost(bool post);
        void benchmark();
        void benchmark_one();
        bool isInStartPosition();
        long perft(int depth);
	void showMoves();
   
    public:
        Searcher *searcher;
        Position *currentPosition;
        MoveParser *moveParser;
        OpeningBook *book;
        TimeControler timeControler;
};

#endif

