/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-Fran?ois, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#include "engine.h"
#include "move.h"
#include "movegenerator.h"
#include <iostream>
#include <cstring>

using namespace std;

const char* Engine::version="0.26 JA";

void Engine::start() {}
void Engine::stop() {}
void Engine::forceMove() {}
void Engine::reset()
{
    //TODO : reset to start position ??
    book->reset();
}

void Engine::setColor(bool color) {}
void Engine::setDepth(int d) {}
void Engine::setPondering(bool pondering) {}
void Engine::setBoard(char *board)
{
  //  useInternalBook=false;
    delete(currentPosition);
    currentPosition=new Position(board);
}

bool Engine::opponentMove(char *moveString)
{
    Move m=moveParser->getMoveFromString(moveString,currentPosition);
    bool valid=false; 


/*    SANMoveParser *moveParserDebug = new SANMoveParser();
    char *move2=moveParserDebug->getStringFromMove(m,currentPosition);
    std::cout<<"\n\n-------------------------"<<std::endl;
    std::cout<<"USER SAN : "<<move2<<std::endl;
    std::cout<<"-------------------------"<<std::endl;
    delete move2;
*/

    
    std::vector<Move> *nextMoves=searcher->getMoveGenerator()->generateMoves(currentPosition);
    std::vector<Move>::iterator iter;
    for(iter=nextMoves->begin(); iter<nextMoves->end(); iter++)
	if((*iter)==m) valid=true;
    delete nextMoves;
    
    if(valid)
    {
        if(useInternalBook)book->doMove(m);
        currentPosition->doMove(m);
        //currentPosition->displayChessboard();
        return true;
    }
    else 
    {
        currentPosition->displayChessboard();
        //currentPosition->displayBitboards();
        
        std::cout<<"usermove:"<<m<<std::endl;
        std::cout<<"possiblemoves:"<<std::endl;
        
        std::vector<Move> *nextMoves=searcher->getMoveGenerator()->generateMoves(currentPosition);
        std::vector<Move>::iterator iter;
        for(iter=nextMoves->begin(); iter<nextMoves->end(); iter++)
            std::cout<<(*iter)<<std::endl;
        delete nextMoves;
        
        return false;
    }
    
    
}

char* Engine::play(float seconds)
{
    Move m;
    
    if(useInternalBook&&book->hasMove()) //verification si coup dans le book
    {
        m=book->getMove();
    }
    else //pas dans le book
    {
        //m=searcher->rootSearch(currentPosition,5);
        m=searcher->IterativeRootSearchTime(currentPosition,seconds);
    }
    
    char *move=moveParser->getStringFromMove(m,currentPosition);

    if(useInternalBook)
        book->doMove(m);
	
    currentPosition->doMove(m);    
    //currentPosition->displayChessboard();

    return(move); //WARNING: delete la chaine qui vient d etre allouee !
}




void Engine::setPost(bool post)
{
    searcher->setPost(post);
}

void Engine::benchmark()
{
    //cout<<"MINIMAX-------------"<<endl;
    //delete searcher;
    //searcher=new MinimaxSearcher(iface);
    //benchmark_one();
    //cout<<"ALPHABETA-----------"<<endl;
    //delete searcher;
    //searcher=new AlphaBetaSearcher(iface);
    //benchmark_one();
    //cout<<"NEGAMAX-------------"<<endl;
    //delete searcher;
    //searcher=new AlphaBetaNegamaxSearcher(iface);
    benchmark_one();
}

void Engine::benchmark_one()
{
    clock_t startTime;
    int a1,a2,a3,nps;
    int depth=5;
    float totalTime;
     
    cout<<"Cassandre benchmarking:"<<endl;
    
    Position p1("1k1r4/1pp4p/2n5/P6R/2R1p1r1/2P2p2/1PP2B1P/4K3 b - - bm e4");
    Position p2("2krr3/pppb1ppp/3b4/3q4/3P3n/2P2N1P/PP2B1P1/R1BQ1RK1 b - - bm Nxg2");
    Position p3("r4rk1/5p2/1n4pQ/2p5/p5P1/P4N2/1qb1BP1P/R3R1K1 w - - bm Ra2");
    
    startTime=clock();
    
    cout<<"Position 1/3 : 1k1r4/1pp4p/2n5/P6R/2R1p1r1/2P2p2/1PP2B1P/4K3 b"<<endl;
    searcher->rootSearch(&p1,depth);
    a1=searcher->analysedPositions;
    
    cout<<"Position 2/3 : 2krr3/pppb1ppp/3b4/3q4/3P3n/2P2N1P/PP2B1P1/R1BQ1RK1 b"<<endl;
    searcher->rootSearch(&p2,depth);
    a2=searcher->analysedPositions;
    
    cout<<"Position 3/3 : r4rk1/5p2/1n4pQ/2p5/p5P1/P4N2/1qb1BP1P/R3R1K1 w"<<endl;
    searcher->rootSearch(&p3,depth);
    a3=searcher->analysedPositions;

    totalTime=(clock()-startTime)/(double)CLOCKS_PER_SEC;
    nps=(int)((a1+a2+a3)/totalTime);
    
    cout<<"Benchmark completed in  : "<<totalTime<<" seconds"<<endl;
    cout<<"Average searching speed : "<<nps<<" nodes/second"<<endl;    
}

bool Engine::isInStartPosition()
{
    Position p("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1");
    return(p==(*currentPosition));
}

long Engine::perft(int depth)
{
    MoveGenerator *moveGenerator=searcher->getMoveGenerator();
    if(depth==0) return 0;
    long n=0;
    std::vector<Move>* nextMoves=moveGenerator->generateMoves(currentPosition);
    std::vector<Move>::iterator iter;
    for(iter=nextMoves->begin(); iter<nextMoves->end(); iter++)
    {
        currentPosition->doMove(*iter);
        if(moveGenerator->isLegal(currentPosition))
        {
            n++;
            n+=perft(depth-1);
        }
        currentPosition->undoMove(*iter);
    }
    delete nextMoves;
    return n;
}

/*
void Engine::show()
{
	currentPosition->displayChessboard();	
}*/

void Engine::showMoves()
{
    MoveGenerator *moveGenerator=searcher->getMoveGenerator();
    std::cout<<"Legal moves:"<<std::endl;
    std::vector<Move>* nextMoves=moveGenerator->generateMoves(currentPosition);
    std::vector<Move>::iterator iter;
    for(iter=nextMoves->begin(); iter<nextMoves->end(); iter++)
    {
        Position oldPos=*currentPosition;
        currentPosition->doMove(*iter);
        if(moveGenerator->isLegal(currentPosition))
        	std::cout<<moveParser->getStringFromMove(*iter,&oldPos)<<std::endl;
        currentPosition->undoMove(*iter);
    }
    delete nextMoves;
}

