/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-Franois, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#include "canmoveparser.h"
#include "position.h"

Move CANMoveParser::getMoveFromString(const char *moveString, Position *p)
{
    char from_t[3],to_t[3];
    int from,to;
    from_t[0]=moveString[0]; from_t[1]=moveString[1]; from_t[2]='\0';
    to_t[0]=moveString[2]; to_t[1]=moveString[3]; to_t[2]='\0';
    Move m=0;
    
    for(int i=0;i<64;i++)
    {
        if(!strcmp(from_t,squareName[i])) from=i;
        if(!strcmp(to_t,squareName[i])) to=i;
    }
    
    m.setMovingPiece(p->pieceAt(from));

    
    //promotion
    if(strlen(moveString)==5)
    {
        m.setPromotion();
        if(p->pieceAt(from)==W_PAWN)
        {
            switch(moveString[4])
            {
                case 'q': m.setPromotionPiece(W_QUEEN); break;
                case 'r': m.setPromotionPiece(W_ROOK); break;
                case 'b': m.setPromotionPiece(W_BISHOP); break;
                case 'n': m.setPromotionPiece(W_KNIGHT); break;
            }
        }
        else if(p->pieceAt(from)==B_PAWN)
        {
            switch(moveString[4])
            {
                case 'q': m.setPromotionPiece(B_QUEEN); break;
                case 'r': m.setPromotionPiece(B_ROOK); break;
                case 'b': m.setPromotionPiece(B_BISHOP); break;
                case 'n': m.setPromotionPiece(B_KNIGHT); break;
            }
        }
    }
    
    //m=m|(((int)(p->pieceAt(from)))<<28);

        if(!p->empty(to)) //capture
        {
            m.setCapture();
            switch(p->pieceAt(to))
            {
                case W_PAWN	: m.setCapturedPiece(W_PAWN); break;
                case W_KNIGHT	: m.setCapturedPiece(W_KNIGHT); break;
                case W_BISHOP	: m.setCapturedPiece(W_BISHOP); break;
                case W_ROOK	: m.setCapturedPiece(W_ROOK); break;
                case W_QUEEN	: m.setCapturedPiece(W_QUEEN); break;
                case W_KING	: m.setCapturedPiece(W_KING); break;
                case B_PAWN	: m.setCapturedPiece(B_PAWN); break;
                case B_KNIGHT	: m.setCapturedPiece(B_KNIGHT); break;
                case B_BISHOP	: m.setCapturedPiece(B_BISHOP); break;
                case B_ROOK	: m.setCapturedPiece(B_ROOK); break;
                case B_QUEEN	: m.setCapturedPiece(B_QUEEN); break;
                case B_KING	: m.setCapturedPiece(B_KING); break;
            }
            
            if(to==56 && (p->flags&whiteShortCastleMask)) m.setBreaksWhiteKingCastle();
            if(to==63 && (p->flags&whiteLongCastleMask)) m.setBreaksWhiteQueenCastle();
            if(to==0 && (p->flags&blackShortCastleMask)) m.setBreaksBlackKingCastle();
            if(to==7 && (p->flags&blackLongCastleMask)) m.setBreaksBlackQueenCastle();
        }

    //TODO: tests roques, roques brises, promotions, en passant, etc....
    
    //roques
    if(m.getMovingPiece()==W_KING && (p->flags&whiteShortCastleMask)) m.setBreaksWhiteKingCastle();
    if(m.getMovingPiece()==W_KING && (p->flags&whiteLongCastleMask)) m.setBreaksWhiteQueenCastle();
    if(m.getMovingPiece()==B_KING && (p->flags&blackShortCastleMask)) m.setBreaksBlackKingCastle();
    if(m.getMovingPiece()==B_KING && (p->flags&blackLongCastleMask)) m.setBreaksBlackQueenCastle();
    if(from==56 && (p->flags&whiteShortCastleMask)) m.setBreaksWhiteKingCastle();
    if(from==63 && (p->flags&whiteLongCastleMask)) m.setBreaksWhiteQueenCastle();
    if(from==0 && (p->flags&blackShortCastleMask)) m.setBreaksBlackKingCastle();
    if(from==7 && (p->flags&blackLongCastleMask)) m.setBreaksBlackQueenCastle();
    
    //en passant
    if(m.getMovingPiece()==W_PAWN && from>16 && from<32 && p->getEnPassantStatus()!=0)
    {
        if(to==(from-7) && p->empty(to))
        {
            m.setCapture();
            m.setEnPassantCapture();
            m.setCapturedPiece(B_PAWN);
        }
        if(to==(from-9) && p->empty(to))
        {
            m.setCapture();
            m.setEnPassantCapture();
            m.setCapturedPiece(B_PAWN);
        }
    }
    if(m.getMovingPiece()==B_PAWN && from>24 && from<40 && p->getEnPassantStatus()!=0)
    {
        if(to==(from+7) && p->empty(to))
        {
            m.setCapture();
            m.setEnPassantCapture();
            m.setCapturedPiece(W_PAWN);
        }
        if(to==(from+9) && p->empty(to))
        {
            m.setCapture();
            m.setEnPassantCapture();
            m.setCapturedPiece(W_PAWN);
        }
    }

    return(m|(from<<6)|to);
}

char* CANMoveParser::getStringFromMove(Move m, Position *p)
{
    char *move=new char[6];
	char* temp = new char[2];
    
    unsigned char from = m.from();
    unsigned char to = m.to();
   unsigned char piece = p->pieceAt( from );
   
    //TODO: test promotion
    
    strcpy(move,MoveParser::squareName[(m>>6)&movementMask]);
    strcat(move,MoveParser::squareName[m&movementMask]);
    
    
    	// capture
		if ( m.isCapture() )
		{
	
			move[6] = '\0';
            move[5] = move[4];
			move[4] = move[3];
			move[3] = move[2];
			move[2] = 'x';				 
			
		}else{
              
          	move[6] = '\0';
            move[5] = move[4];
			move[4] = move[3];
			move[3] = move[2];
			move[2] = '-';	
        }	
        
        // castling
        
        	    // roque blanc
	if ( piece==W_KING && from==59 && ( to==57 || to==61 ) )
	{
		if ( to==57 )
			strcpy( move, "O-O" );
		else
			strcpy( move, "O-O-O" );
	}
	// roque noir
	else if ( piece==B_KING && from==3 && ( to==1 || to==5 ) )
	{
		if ( to==1 )
			strcpy( move, "O-O" );
		else
			strcpy( move, "O-O-O" );
	}

    
     
    
    if(m.isPromotion())
    {
        switch(m.promotionPiece())
        {
            case W_QUEEN: strcat(move,"q"); break;
            case W_ROOK: strcat(move,"r"); break;
            case W_BISHOP: strcat(move,"b"); break;
            case W_KNIGHT: strcat(move,"n"); break;
            case B_QUEEN: strcat(move,"q"); break;
            case B_ROOK: strcat(move,"r"); break;
            case B_BISHOP: strcat(move,"b"); break;
            case B_KNIGHT: strcat(move,"n"); break;
        }
    }
    
    return move;
}
