/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-Franois, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#ifndef CASSANDRE_BITBOARDTOOLKIT_H
#define CASSANDRE_BITBOARDTOOLKIT_H 1


#ifdef _WIN32
typedef unsigned __int64  bitboard;
#else
typedef unsigned long long int bitboard;
#endif

/**
 * This class provides various static methods and precomputed arrays used to
 * manipulate bitboards.
 */
class BitboardToolkit
{
    public:
        static BitboardToolkit* instance();
        static void displayBitboard(bitboard board);
        int popCnt(register bitboard a);
        int firstOne(bitboard arg1);
        int lastOne(bitboard arg1);

        static bitboard zobrist[6][2][64];
	static bitboard zobristColor;

        const static bitboard FFMask;
        bitboard bitMask[64]; //masques 1 bit
    
    protected:
        BitboardToolkit()
        {
            initBitOperations();
            initBitMask();
            initZobrist();
        }
        
    private:
        const static int inbits[256];
        static BitboardToolkit* _instance;
        unsigned char  first_ones[65536];
        unsigned char  last_ones[65536];
        void initBitOperations(); //initialize first_ones and last_ones
        void initBitMask(); //initialise bitMask & FFMask
       bitboard rand64();

        void initZobrist();
};

inline BitboardToolkit* BitboardToolkit::instance()
{
    if(!_instance) _instance=new BitboardToolkit;
    return _instance;
}

#endif
