/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-Franois, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#include "bitboardtoolkit.h"
#include <cmath>
#include <cstdio>
#include <stdlib.h> // pour rand()

#define MACOS

BitboardToolkit* BitboardToolkit::_instance=0;
const bitboard BitboardToolkit::FFMask=255;

bitboard BitboardToolkit::zobrist[6][2][64];
bitboard BitboardToolkit::zobristColor;

// A list of the number of bits in numbers from 0-255.
const int      BitboardToolkit::inbits[256] = {
    0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
    3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
    4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
};


void BitboardToolkit::initBitOperations()
{
  int i, j;
  int maskl,maskr;
  first_ones[0]=16;
  last_ones[0]=16;
  for (i=1;i<65536;i++){
    maskl=32768;
    for(j=0;j<16;j++){
      if ((maskl & i)){
        first_ones[i]=j;
        break;
      }
      maskl=maskl>>1;
    }
    maskr=1;
    for(j=0;j<16;j++){
      if ((maskr & i)){
        last_ones[i]=15-j;
        break;
      }
      maskr=maskr<<1;
    }
  }
}

void BitboardToolkit::initZobrist()
{
  for(int i=0;i<6;i++)
    for(int j=0;j<2;j++)
      for(int k=0;k<64;k++)
                 BitboardToolkit::zobrist[i][j][k] = rand64();
 zobristColor = rand64();
}

bitboard BitboardToolkit::rand64()
{
   return rand() ^ ((bitboard)rand() << 15) ^ ((bitboard)rand() << 30) ^((bitboard)rand() << 45) ^ ((bitboard)rand() << 60);
}
/*
int BitboardToolkit::popCnt(register bitboard a) {
  register int c=0;

  while(a) {
    c++;
    a &= a - 1;
  }
  return(c);
}*/

// contage de bits par table lookup (D. Corbit)
int BitboardToolkit::popCnt(register bitboard a)
{
    return inbits[(unsigned char) a] +
    inbits[(unsigned char) (a >> 8)] +
    inbits[(unsigned char) (a >> 16)] +
    inbits[(unsigned char) (a >> 24)] +
    inbits[(unsigned char) (a >> 32)] +
    inbits[(unsigned char) (a >> 40)] +
    inbits[(unsigned char) (a >> 48)] +
    inbits[(unsigned char) (a >> 56)];
}

int BitboardToolkit::firstOne(bitboard arg1) {
    if (arg1>>48)
      return (63-first_ones[arg1>>48]);
    if ((arg1>>32)&65535)
      return (63-(first_ones[(arg1>>32)&65535]+16));
    if ((arg1>>16)&65535)
      return (63-(first_ones[(arg1>>16)&65535]+32));
    return (63-(first_ones[arg1&65535]+48));
}
  
int BitboardToolkit::lastOne(bitboard arg1) {
    if (arg1&65535)
      return (63-(last_ones[arg1&65535]+48));
    if ((arg1>>16)&65535)
      return (63-(last_ones[(arg1>>16)&65535]+32));
    if ((arg1>>32)&65535)
      return (63-(last_ones[(arg1>>32)&65535]+16));
    return (63-(last_ones[arg1>>48]));
}

void BitboardToolkit::initBitMask()
{
	int i;
	bitboard x;
	x=1;
	for(i=0;i<64;i++)
	{
		bitMask[i]=x;
		x=x<<1;
	}
}

void BitboardToolkit::displayBitboard(bitboard board)
{
  int i,j,x;
  for(i=7;i>=0;i--) {
    printf("  %2d ",i*8);
    x=board&255;
    board>>=8;
    for(j=128;j>0;j=j>>1)
      if(x & j) 
        printf("X ");
      else
        printf("- ");
    printf("\n");
  }
}

