/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-François, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#ifndef CASSANDRE_ALPHABETA_NEGAMAX_SEARCHER_H
#define CASSANDRE_ALPHABETA_NEGAMAX_SEARCHER_H 1

#include <ctime>
#include "move.h"
#include "position.h"
#include "movegenerator.h"
#include "canmoveparser.h"
#include "sanmoveparser.h"

#include "evaluator.h"
#include "alfevaluator.h"

#include "searcher.h"

#define PV_BUFF 512

/**
 * An implementation of the standard AlphaBeta with negamax searching algorithm.
 */
class AlphaBetaNegamaxSearcher : public Searcher
{
    public:
        AlphaBetaNegamaxSearcher(Interface *i) : Searcher(i)
        {
            useQuiescence=true;
        }
        //Move rootSearch(Position *current, int depth);
        void treeSearch(Position *current, std::vector<SearchElement> *elements, int depth);
                
    private:
        int alphabeta(Position *p, int depth, int alpha, int beta);        
        int quiesce(Position *p, int depth, int alpha, int beta);
        bool useQuiescence;
        
         //gestion de la pv
        CANMoveParser moveParser;
        Move pv[PV_BUFF][PV_BUFF];
        int ply, pv_length[PV_BUFF];
        void displayPV(Position *current, int value, int depth);
        char pvString[512];
        
        clock_t startTime; //mesure temps
};

#endif
