/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-François, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#include "alphabetanegamaxsearcher.h"
#include <iostream>
#include <cstring>

int AlphaBetaNegamaxSearcher::alphabeta(Position *p, int depth, int alpha, int beta)
{
    int best,value;
    analysedPositions++;
    pv_length[ply]=ply;
    Move bestMove=0;

    //on retourne de suite s'il manque un roi
    if(!(p->w_occupied^p->w_pawn^p->w_knight^p->w_bishop^p->w_rook^p->w_queen))
    {
        if(p->flags&playerMask) return -mateValue;
        else return mateValue;
    }
    if(!(p->b_occupied^p->b_pawn^p->b_knight^p->b_bishop^p->b_rook^p->b_queen))
    {
        if(p->flags&playerMask) return mateValue;
        else return -mateValue;
    }
    //on returne si temrinal
    if(depth<=0) 
    {
        if(useQuiescence) return quiesce(p,depth-1,-beta,-alpha);
        else
        {
            if(p->flags&playerMask) return evaluator->evaluate(p);
            else return -(evaluator->evaluate(p));
        }
    }

    std::vector<Move> *nextMoves=moveGenerator->generateMoves(p);
    
    best=-infinity;
    std::vector<Move>::iterator iter;
    for(iter=nextMoves->begin(); (best<beta)&&iter<nextMoves->end(); iter++)
    {
        ply++;
        p->doMove(*iter);
        
        if(best>alpha) alpha=best;
        value=-alphabeta(p,depth-1,-beta,-alpha);
        ply--;
        if(value>best)
        {
            best=value;
            bestMove=*iter;
            //update pv
            pv[ply][ply]=(*iter);
            for(int j=ply+1;j<pv_length[ply+1];j++)
                pv[ply][j]=pv[ply+1][j];
            pv_length[ply]=pv_length[ply+1];
        }
        p->undoMove(*iter);
    }
    delete nextMoves;
    return best; 
}


void AlphaBetaNegamaxSearcher::treeSearch(Position *current, std::vector<SearchElement> *elements, int depth)
{
    startTime=clock();
    double totalTime;

    //std::vector<Move> *possibleMoves=moveGenerator->generateMoves(current);
    std::vector<SearchElement>::iterator iter;
    int value;
    Move bestMove;
    analysedPositions=0;
    
    ply=1;
    pv_length[ply]=ply;
    
    value=-infinity;
    int alpha=value;
    for(iter=elements->begin(); iter<elements->end(); iter++)
    {
        ply++;
        current->doMove((*iter).move);
        if(moveGenerator->isLegal(current))
        {
            //int mmv=-alphabeta(current,depth-1,-1000000,1000000);
            if(value>alpha) alpha=value;
            int mmv=-alphabeta(current,depth-1,-infinity,-alpha);
            
            (*iter).value=mmv;
            ply--;
            if(mmv>value)
            {
                value=mmv;
                bestMove=((*iter).move);
              
                //update pv
                pv[ply][ply]=bestMove;
                for(int j=ply+1;j<pv_length[ply+1];j++)
                    pv[ply][j]=pv[ply+1][j];
                pv_length[ply]=pv_length[ply+1];
                
                if(post) displayPV(current,value,depth);
            }
            //displayPV(current,value,depth);
        } else ply--;
        current->undoMove((*iter).move);
    }
    
    std::cout<<"Analysed:"<<analysedPositions<<std::endl;
    totalTime=(clock()-startTime)/(double)CLOCKS_PER_SEC;
    iface->displayTimeNPS(totalTime,(int)(analysedPositions/totalTime));

    //pour conserver la meilleure ligne dans le tri
    for(iter=elements->begin(); iter<elements->end(); iter++)
    	if((*iter).move==bestMove) (*iter).value++;
}

void AlphaBetaNegamaxSearcher::displayPV(Position *current, int value, int depth)
{
    Position p=(*current);
    char *moveString;
    strcpy(pvString,"");

    for (int i = 1; i < pv_length[1]; i++)
    {
        moveString=moveParser.getStringFromMove(pv[1][i], &p);
        strcat(pvString,moveString);
        strcat(pvString," ");
        delete moveString;
        p.doMove(pv[1][i]);
    }

    iface->displayThinking(depth, value, (int)(((clock()-startTime)/(double)CLOCKS_PER_SEC)*100), analysedPositions, pvString);
}

int AlphaBetaNegamaxSearcher::quiesce(Position *p, int depth, int alpha, int beta)
{
    
    int best,value;
    analysedPositions++;
    pv_length[ply]=ply;
    Move bestMove=0;
    
    //on retourne de suite s'il manque un roi
    if(!(p->w_occupied^p->w_pawn^p->w_knight^p->w_bishop^p->w_rook^p->w_queen))
    {
        if(p->flags&playerMask) return -mateValue;
        else return mateValue;
    }
    if(!(p->b_occupied^p->b_pawn^p->b_knight^p->b_bishop^p->b_rook^p->b_queen))
    {
        if(p->flags&playerMask) return mateValue;
        else return -mateValue;
    }
    
    //test prof max
    if(depth<=-6)
    {
        if(p->flags&playerMask) return evaluator->evaluate(p);
        else return -(evaluator->evaluate(p));
    }

    std::vector<Move> *nextMoves=moveGenerator->generateCaptureMoves(p);
    //on returne si plus de capture
    if(nextMoves->empty()) 
    {
        delete nextMoves;
        if(p->flags&playerMask) return evaluator->evaluate(p);
        else return -(evaluator->evaluate(p));
    }
    
    //best= -100000;
    //Give the option of 'not moving'
    if(p->flags&playerMask) best=evaluator->evaluate(p);
    else best=-(evaluator->evaluate(p));
    
    std::vector<Move>::iterator iter;
    for(iter=nextMoves->begin(); (best<beta)&&iter<nextMoves->end(); iter++)
    {
        ply++;
        p->doMove(*iter);
        
        if(best>alpha) alpha=best;
        value=-quiesce(p,depth-1,-beta,-alpha);
        ply--;
        if(value>best)
        {
            best=value;
            bestMove=*iter;
            //update pv
            pv[ply][ply]=(*iter);
            for(int j=ply+1;j<pv_length[ply+1];j++)
                pv[ply][j]=pv[ply+1][j];
            pv_length[ply]=pv_length[ply+1];
        }
        p->undoMove(*iter);
    }
    delete nextMoves;
    return best; 
}
