/* This file is part of Cassandre.
   Copyright (c) 2003 Romang Jean-Franois, Adolph Thomas, Grundrich Raphael

   Cassandre is based on the DessChess program, a student project realised at
   University Louis Pasteur in Strasbourg, France ; under the direction of
   professor J.Korczak.

   Cassandre is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Cassandre is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Cassandre; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     jeff@proxone.net
*/

#include "alfevaluator.h"


	// position bonus

const int AlfEvaluator::bonus_bishop[64] = { 	
                        -5,-5,-5,-5,-5,-5,-5,-5,
                        -5,10, 5,10,10, 5,10,-5,
                        -5, 5, 3,12,12, 3, 5,-5,
                        -5, 3,12, 3, 3,12, 3,-5,
                        -5, 3,12, 3, 3,12, 3,-5,
                        -5, 5, 3,12,12, 3, 5,-5,
                        -5,10, 5,10,10, 5,10,-5,
                        -5,-5,-5,-5,-5,-5,-5,-5,};

const int AlfEvaluator::bonus_knight[64] = {	
                        -10,-5,-5,-5,-5,-5,-5,-10,
                        -5 , 0, 0, 3, 3, 0, 0,-5,
                        -5 , 0, 5, 5, 5, 5, 0,-5,
                        -5 , 0, 5,10,10, 5, 0,-5,
                        -5 , 0, 5,10,10, 5, 0,-5,
                        -5 , 0, 5, 5, 5, 5, 0,-5,
                        -5 , 0, 0, 3, 3, 0, 0,-5,
                        -10,-5,-5,-5,-5,-5,-5,-10};

const int AlfEvaluator::bonus_black_pawn[64] = {	
                                0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0,-5,-5, 10, 10, 10,
                                1, 2, 3, 4, 4, 3, 2, 1,
                                2, 4, 6, 8, 8, 6, 4, 2,
                                3, 6, 9,12,12, 9, 6, 3,
                                4, 8,12,16,16,12, 8, 4,
                                5,10,15,20,20,15,10, 5,
                                0, 0, 0, 0, 0, 0, 0, 0};

const int AlfEvaluator::bonus_white_pawn[64] = {	    
                            0,0,0,0,0,0,0,0,
                            5,10,15,20,20,15,10,5,
                            4,8,12,16,16,12,8,4,
                            3,6,9,12,12,9,6,3,
                            2,4,6,8,8,6,4,2,
                            1,2,3,4,4,3,2,1,
                            0,0,0,-5,-5,10,10,10,
                            0,0,0,0,0,0,0,0};

// opening and middlegame for black king positioning
const int AlfEvaluator::bonus_black_king[64] = {

                        2 ,10, 7, 0, 0, 4, 10, 2,
                        -3,-3,-5,-5,-5,-5,-3,-3,
                        -5,-5,-8,-8,-8,-8,-5,-5,
                        -8,-8,-13,-13,-13,-13,-8,-8,
                        -13,-13,-21,-21,-21,-21,-13,-13,
                        -21,-21,-34,-34,-34,-34,-21,-21,
                        -34,-34,-55,-55,-55,-55,-34,-34,
                        -55,-55,-89,-89,-89,-89,-55,-55
};

// opening and middlegame for white king positioning
const int AlfEvaluator::bonus_white_king[64] = {

                        -55,-55,-89,-89,-89,-89,-55,-55,
                        -34,-34,-55,-55,-55,-55,-34,-34,
                        -21,-21,-34,-34,-34,-34,-21,-21,
                        -13,-13,-21,-21,-21,-21,-13,-13,
                        -8,-8,-13,-13,-13,-13,-8,-8,
                        -5,-5,-8,-8,-8,-8,-5,-5,
                        -3,-3,-5,-5,-5,-5,-3,-3,
                        2,10,7,0,0,4,10,2
};

// positioning of both kings endgame
const int AlfEvaluator::bonus_end_king[64] = {
                        -5,-3,-1,0,0,-1,-3,-5,
                        -3,5,5,5,5,5,5,-3,
                        -1,5,10,10,10,10,5,-1,
                        0,5,10,15,15,10,5,0,
                        0,5,10,15,15,10,5,0,
                        -1,5,10,10,10,10,5,-1,
                        -3,5,5,5,5,5,5,-3,
                        -5,-3,-1,0,0,-1,-3,-5
};




int AlfEvaluator::evaluate(Position *p)
{
	int score=0,i;
    bitboard analysedPieces;

    analysedPieces=p->w_pawn;
    while(analysedPieces)
    {
        i=bbtk->firstOne(analysedPieces);
        analysedPieces=analysedPieces^bitMask[i];
        score+=100+bonus_white_pawn[i];
    }
    
    analysedPieces=p->w_knight;
    while(analysedPieces)
    {
        i=bbtk->firstOne(analysedPieces);
        analysedPieces=analysedPieces^bitMask[i];
        score+=300+bonus_knight[i];
    }
    
    analysedPieces=p->w_bishop;
    while(analysedPieces)
    {
        i=bbtk->firstOne(analysedPieces);
        analysedPieces=analysedPieces^bitMask[i];
        score+=300+bonus_bishop[i];		
    }
    
    analysedPieces=p->w_rook;
    while(analysedPieces)
    {
        i=bbtk->firstOne(analysedPieces);
        analysedPieces=analysedPieces^bitMask[i];
        score+=500;		
    }
    
    analysedPieces=p->w_queen;
    while(analysedPieces)
    {
        i=bbtk->firstOne(analysedPieces);
        analysedPieces=analysedPieces^bitMask[i];
        score+=1000;		
    }
    
    analysedPieces=p->b_pawn;
    while(analysedPieces)
    {
        i=bbtk->firstOne(analysedPieces);
        analysedPieces=analysedPieces^bitMask[i];
        score-=(100+bonus_black_pawn[i]);
    }
    
    analysedPieces=p->b_knight;
    while(analysedPieces)
    {
        i=bbtk->firstOne(analysedPieces);
        analysedPieces=analysedPieces^bitMask[i];
        score-=(300+bonus_knight[i]);
    }
    
    analysedPieces=p->b_bishop;
    while(analysedPieces)
    {
        i=bbtk->firstOne(analysedPieces);
        analysedPieces=analysedPieces^bitMask[i];
        score-=(300+bonus_bishop[i]);		
    }
    
    analysedPieces=p->b_rook;
    while(analysedPieces)
    {
        i=bbtk->firstOne(analysedPieces);
        analysedPieces=analysedPieces^bitMask[i];
        score-=500;		
    }
    
    analysedPieces=p->b_queen;
    while(analysedPieces)
    {
        i=bbtk->firstOne(analysedPieces);
        analysedPieces=analysedPieces^bitMask[i];
        score-=1000;		
    }
   
    score+=(bonus_white_king[bbtk->firstOne(p->w_occupied^(p->w_pawn|p->w_knight|p->w_bishop|p->w_rook|p->w_queen))]);
    score-=(bonus_black_king[bbtk->firstOne(p->b_occupied^(p->b_pawn|p->b_knight|p->b_bishop|p->b_rook|p->b_queen))]);

    return score;

}

