// Copyright 2005-2007 by Jon Dart. All Rights Reserved.

#ifndef _THREAD_POOL_H
#define _THREAD_POOL_H

#include "types.h"

class Search;
class SearchController;
struct NodeInfo;
struct split_t;

class ThreadPool;

struct ThreadInfo {
   enum State { Idle, Working, Waiting, Terminating };
   ThreadInfo(int i);
   virtual ~ThreadInfo();
   State state;
   Search *work;
   NodeInfo *parentNode;
   ThreadPool *pool;
   THREAD thread_id;
  int master;
#ifdef _WIN32
   HANDLE hEvent1;
#else
   int semid;  // semaphore id
   unsigned count;
#endif
   int index;
   void start();
   // wait for signal; return 1 if interrupted
   int wait();
   int wait(unsigned millisec);
   void signal();
   void reset();
};

extern void idle_loop(ThreadInfo *ti, split_t *split);

class ThreadPool {
public:

   // create a thread pool with n threads
   ThreadPool(SearchController *,int n);

   virtual ~ThreadPool();

   ThreadInfo *mainThread() const {
     return data[0];
   }

   // obtain an idle thread if possible, returns 
   // non-null if successful
   ThreadInfo *checkOut(Search *,NodeInfo *,int ply,int depth);

   // Do a quick check for thread availability (w/o locking)
   int checkAvailable() {
     for (int i=0; i<nthreads;i++) {
       if (data[i]->state == ThreadInfo::Idle) return 1;
     }
     return 0;
   }

   // return a thread to the pool
   void checkIn(ThreadInfo *);

   int activeCount();

   void clearHashTables(SearchController *);

   // resize the thread pool
   void resize(int n, SearchController *);

private:
   void shutDown();

   LockDefine(poolLock);
   ThreadInfo **data;
   int nthreads;
};

#ifdef _THREAD_TRACE
extern void log(const string &s);
extern void log(const string &s,int param);
#endif
#endif
