#ifndef _STATS_H
#define _STATS_H

#include "constant.h"
#include "config.h"
#define MAX_PV 10

enum StateType {NormalState,Terminated,Check,Checkmate,
                Stalemate,Draw,Resigns};

// This structure holds information about a search
// after it has completed.
struct Statistics
{
   StateType state;
   int value;
   int display_value;
   int complete; // if at end of iteration
   int multipv_count; // only for UCI
   Move best_line[Constants::MaxPly];
   char best_line_image[256];
   time_t elapsed_time; // in centiseconds
   unsigned depth;
   uint64 num_moves;
   uint64 num_nodes;
   uint64 num_qnodes;
   int mvtot; // total root moves 
   int mvleft; // moves left to analyze at current depth
   unsigned long tb_probes; // tablebase probes
   unsigned long tb_hits;   // tablebase hits
   uint64 futility_pruning;
   uint64 num_null_cuts;
   uint64 num_razored;
   uint64 check_extensions, recap_extensions, threat_extensions,
     pawn_extensions, forced_extensions;
   uint64 hash_hits, hash_inserts, hash_searches, hash_replaces,
     hash_inserts_failed, new_hash_inserts;
#if defined(SMP) && defined(SMP_STATS)
   uint64 splits;
   uint64 samples, threads;
#endif
#ifdef MOVE_ORDER_STATS
   int move_order[4];
   int move_order_count;
#endif
   int end_of_game;
   Statistics();
   void clear();
   void print_nps(char *);
};

#endif
