// Copyright 1994-2006 by Jon Dart. All Rights Reserved.

#include "stats.h"
#include "constant.h"
#include <iomanip>

Statistics::Statistics()
{
   clear();
}

void Statistics::clear()
{
   state = NormalState;
   value = 0;
   elapsed_time = 0;
   int i;
   best_line_image[0] = '\0';
   for (i = 0; i < Constants::MaxPly; i++) {
        best_line[i] = NullMove;
   }
   num_moves = num_nodes = num_qnodes = depth = 0;
   hash_hits =
      hash_searches = hash_inserts = new_hash_inserts =
      hash_replaces = hash_inserts_failed = 0L;
   end_of_game = 0;
   mvleft = mvtot = 0;
   tb_probes = tb_hits = 0;
#ifdef MOVE_ORDER_STATS
   move_order_count = 0;
   for (i = 0; i < 4; i++) move_order[i]=0;
#endif
   futility_pruning = num_null_cuts = num_razored = 0L;
   check_extensions = recap_extensions =  threat_extensions = 
     pawn_extensions = forced_extensions = 0L;
#if defined(SMP) && defined(SMP_STATS)
   splits = samples = threads = 0L;
#endif
}

void Statistics::print_nps(char *buf) {
  double nps = (100.0*(float)num_nodes)/((float)elapsed_time)/1000.0;
#if defined(__GNUC__) && _GNUC_PREREQ(3,2)
  std::ostringstream o;
#else
   strstream o(buf,128,ios::out);
#endif
   o.setf(ios::fixed);
   o << setprecision(2);
   if (nps >= 1000.0) {
     o << nps/1000.0 << "M";
   }
   else {
      o << nps << "k";
   }
   o << '\0';
#if defined(__GNUC__) && _GNUC_PREREQ(3,2)
   strcpy(buf,o.str().c_str());
#endif
}
