// Copyright 2006-2007 by Jon Dart. All Rights Reserved.

#ifndef _SEARCHC_H
#define _SEARCHC_H

#include "constant.h"
#include "chess.h"

struct SearchContext {
    SearchContext() {
      clear_killer();
      clear_history();
    }

    void clear_killer(); 
    void set_killer(const Move & move,unsigned ply);
    void get_killers(unsigned ply,Move &k1,Move &k2) const;

    void clear_history();

    int history_score_for_ordering(Move m,ColorType) const;
    int history_score_for_pruning(Move m,ColorType) const;

    static FORCEINLINE int history_index(Move m,ColorType side) {
       return StartSquare(m)*64 + DestSquare(m) + 4096*(int)side;
    }

    Move Killers1[Constants::MaxPly];
    Move Killers2[Constants::MaxPly];

    struct HistoryEntry {
      int hits, total;
    } History[8192];
    int History2[16][64];
};

#endif
