// Copyright 2006-2007 by Jon Dart. All Rights Reserved.

#include "searchc.h"

void SearchContext::clear_killer() {
   for (int i = 0; i < Constants::MaxPly; i++) {
      Killers1[i] = Killers2[i] = NullMove;
   }
}

void SearchContext::set_killer(const Move & move,unsigned ply) {
    if (!MovesEqual(move,Killers1[ply])) {
       Killers2[ply] = Killers1[ply];
    }
    Killers1[ply] = move;
}

void SearchContext::get_killers(unsigned ply,Move &k1,Move &k2) const {
    k1 = Killers1[ply]; k2 = Killers2[ply];
}

int SearchContext::history_score_for_pruning(Move m,ColorType side) const {
  return (History[history_index(m,side)].hits*Constants::HISTORY_MAX)/
    History[history_index(m,side)].total;
}

int SearchContext::history_score_for_ordering(Move m,ColorType side) const {
   return History2[MakePiece(PieceMoved(m),side)][DestSquare(m)];
}

void SearchContext::clear_history() {
  int i;
  for (i = 0; i < 8192; i++) {
    History[i].total = 1;
    History[i].hits = 1;
  }
  for (i = 0; i < 16; i++) {
    for (int j = 0; j < 64; j++) {
      History2[i][j] = 0;
    }
  }
}


