// Copyright 1992-2007 by Jon Dart.  All Rights Reserved.

#ifndef _SCORING_H
#define _SCORING_H

#include "board.h"
#include "bitprobe.h"
#include "config.h"

class Search;
struct QSearchHashEntry;

class Scoring
{
    // This class does static evaluation of chess positions.

    public:
		
    enum { INVALID_SCORE = -Constants::BIG };

    static void init();
        
    static void cleanup();
		
    // evaluate "board" from the perspective of the side to move.
    static int evalu8( const Board &board, Search * );

    // return a positional score
    static int positional_score( const Board &board, 
     Search *,int alpha, int beta, QSearchHashEntry *hash = NULL );

    // return a material score
    static int material_score( const Board &board );
		
    static int repetition_draw( const Board &board );

    static int material_draw( const Board &board );
        
    // checks for legal draws plus certain other theoretically
    // draw positions
    static int is_draw(const Board &board);
        
    // Check only for those positions which are not legal draws
    // but are theoretically drawn
    static int is_theoretical_draw(const Board &board);
        
    // Check only for legal draws
    static int is_legal_draw(const Board &board);

    // Turn a score into a formatted string (mate scores are
    // shown like +Mate6).
    static void print_score( int score, char *buf );

    static void print_score_uci( int score, char *buf );

    static inline int uncatchable(ColorType sideToMove,
                 Square pawnpos,
                 Square kp,
                 Square oppkp,
                 ColorType side) {
      return lookupBitbase(kp,pawnpos,oppkp,side,sideToMove);
    }

#ifdef EVAL_STATS
    static void clearStats();
#endif

    // Try to return a score based on bitbases
    static int tryBitbase(const Board &board);

    static int sq_king_test(Square oppkp,Square pawnpos,ColorType side,
      ColorType sideToMove);

 private:
    static int positional_score( const Board &, 
       const Search *, ColorType );
};

#endif






























































































































































































































































































































































































































































































































































































































































































































