// Copyright 1999, 2005 by Jon Dart.  All Rights Reserved.

#ifndef _POSITION_BOOK_H_
#define _POSITION_BOOK_H_

#include "bookdefs.h"
#include "bookinfo.h"
#include "bookutil.h"
#include "board.h"
#include "pinfo.h"

class PositionBook
{
        // Provides a simple book for position learning.
        // Basically a persistent hash table.

        public:

        PositionBook();
        // opens book
                
        ~PositionBook();
        // closes book file
                
        const int is_open() const
        {
           return open;
        }
        
        void add(const Board &,const Hash_Entry &info);
        
        int size() const;
        
        int lookup(const Board &,hash_t hashCode,Position_Info &);
                
protected:
               
	void init(const char *book_path,FILE_HANDLE book_file);

       void *pBook;
       byte *pPage;
       FILE_HANDLE book_file;
       MEM_HANDLE hFileMapping;
       int open, newBook, learn_size;
       Book_Header hdr;

 private:       
       BookUtil bu;
};           


#endif
