// Copyright 1997, 1998 by Jon Dart.  All Rights Reserved.

#ifndef _PAWN_ENTRY_H
#define _PAWN_ENTRY_H

#include "types.h"
#include "bitmap.h"

class Pawn_Entry
{
     // defines one entry in the pawn hash table.

public:

     Pawn_Entry()
     : hc(0xffffffffffffffffULL)
     {
     }

     // two entries are equivalent if they have the same hash code bytes.
     int is_equal( const Pawn_Entry &e) const
     {
         return hc == e.hc;
     }
	    
     hash_t hash_code() const
     {
        return hc;
     }
     
     hash_t hc; // hashcode

     struct PawnData {
        byte passers_count;
        Square passers[8];
        int score;
        int center_score;
        byte first_passer,last_passer;
        byte protected_pp;
        byte w_square_pawns,b_square_pawns;
        int weak_files;
        byte open_files;
        byte pawns_on_2nd_rank;
        byte outside;
        Bitmap opponent_pawn_attacks;
        byte max_passer_rank,max_passer_rank_sq,passer_file_span;
        byte weakopen;
        byte locked;
        Bitmap blocked;
     };

     Pawn_Entry::PawnData w_pawn_entry;
     Pawn_Entry::PawnData b_pawn_entry;

     int FileOpen( int file ) const {
       return (w_pawn_entry.open_files & b_pawn_entry.open_files) & (1<<(file-1));
     }

     FORCEINLINE int FileOpen( int file, ColorType side ) const {
       if (side == White)
         return w_pawn_entry.open_files & (1<<(file-1));
       else
         return b_pawn_entry.open_files & (1<<(file-1));
     }
};

#endif
