// Copyright 2000-2008 by Jon Dart. All Rights Reserved.
#ifndef _OPTIONS_H
#define _OPTIONS_H

#include <string>
using namespace std;

class Options
{
 public:
  struct BookOptions {
    BookOptions() 
      : selectivity(0),
        random(0),
        book_enabled(1)
    { }

    int selectivity;
    int random;
    int book_enabled;
  } book;

  struct SearchOptions {
    SearchOptions() : null_depth_reduction(2),
      check_extensions(1),
      pawn_push_extensions(1),
      recapture_extensions(0),
      threat_extensions(1),
      forced_extensions(1),
      late_move_reductions(1),
      checks_in_qsearch(1),
      hash_table_size(8000),
      can_resign(1),
      resign_threshold(-500),
      use_tablebases(1),
      tb_cache_size(1024),
      multipv(1),
      ncpus(1)
    {}

   int null_depth_reduction; // 0, 1, or 2
   int check_extensions;
   int pawn_push_extensions;
   int recapture_extensions;
   int threat_extensions;
   int forced_extensions;
   int late_move_reductions;
   int checks_in_qsearch;
   int hash_table_size;
   int can_resign;
   int resign_threshold;
   int num_killers;
   int use_tablebases;
   int tb_cache_size;
   int multipv; // for UCI only
   string tablebase_location;
   int ncpus;
 
  } search;

   struct LearningOptions {
     LearningOptions() 
     : position_learning(1),
       position_learning_threshold(33),
       position_learning_horizon(5),
       position_learning_minDepth(7),
       score_learning(1),
       score_learning_horizon(5),
       score_learning_threshold(33),
       score_learning_minDepth(7),
       result_learning(1)
     {}
    int position_learning;
    int position_learning_threshold;
    int position_learning_horizon;
    int position_learning_minDepth;
    int score_learning;
    int score_learning_horizon;
    int score_learning_threshold;
    int score_learning_minDepth;
    int result_learning;
   } learning;


   // Constructor, sets default options
   Options() :
     log_enabled(1),
     log_append(0),
     store_games(1)
   {
   }

  // sets options based on a .rc file
  int init(const char *fileName);

  int log_enabled;
  int log_append;
  int store_games;
  string log_pathname;
  string game_pathname;

 private:
  void set_option(const string &name,const string &value);
};

#endif
