// Copyright 2002-2008 by Jon Dart. All Rights Reserved.
#include "options.h"

#include <fstream>
#include <ctype.h>
#include <stdio.h>
#include <iostream>

using namespace std;

static void set_int_option(string name,int &value, string valueString) {
  if (sscanf(valueString.c_str(),"%d",&value) != 1)
    cerr << "warning: invalid value for option " << name << " (expected integer)"  << endl;
}

static void set_boolean_option(string name,int &value, string valueString) {
  if (valueString == "true")
    value = 1;
  else if (valueString == "false") 
    value = 0;
  else
    cerr << "warning: invalid value for option " << name << " (expected 'true' or 'false')"  << endl;
}

void Options::set_option(const string &name, const string &value) {
  if (name == "log.enabled") {
    set_boolean_option(name,log_enabled,value);
  }
  else if (name == "log.append") {
    set_boolean_option(name,log_append,value);
  }
  else if (name == "log.pathName") {
    log_pathname = value;
  }
  else if (name == "store_games") {
    set_boolean_option(name,store_games,value);
  }
  else if (name == "game_pathname") {
    game_pathname = value;
  }
  else if (name == "book.book_enabled") {
    set_boolean_option(name,book.book_enabled,value);
  }
  else if (name == "book.selectivity") {
    set_int_option(name,book.selectivity,value);
  }
  else if (name == "book.random") {
    set_int_option(name,book.random,value);
  }
  else if (name == "learning.score_learning") {
    set_boolean_option(name,learning.score_learning,value);
  }
  else if (name == "learning.score_learning.horizon") {
    set_int_option(name,learning.score_learning_horizon,value);
  }
  else if (name == "learning.score_learning.threshold") {
    int tmp;
    set_int_option(name,tmp,value);
    learning.score_learning_threshold = (64*tmp)/100;
  }
  else if (name == "learning.score_learning.minDepth") {
    set_int_option(name,learning.score_learning_minDepth,value);
  }
  else if (name == "learning.result_learning") {
    set_boolean_option(name,learning.result_learning,value);
  }
  else if (name == "learning.position_learning") {
    set_boolean_option(name,learning.position_learning,value);
  }
  else if (name == "learning.position_learning.threshold") {
    int tmp;
    set_int_option(name,tmp,value);
    learning.position_learning_threshold = (64*tmp)/100;
  }
  else if (name == "learning.position_learning.minDepth") {
    set_int_option(name,learning.position_learning_minDepth,value);
  }
  else if (name == "search.null_depth_reduction") {
    set_int_option(name,search.null_depth_reduction,value);
  }
  else if (name == "search.extensions.recapture") {
    set_boolean_option(name,search.recapture_extensions,value);
  }
  else if (name == "search.extensions.check") {
    set_boolean_option(name,search.check_extensions,value);
  }
  else if (name == "search.extensions.forced") {
    set_boolean_option(name,search.forced_extensions,value);
  }
  else if (name == "search.extensions.pawn") {
    set_boolean_option(name,search.pawn_push_extensions,value);
  }
  else if (name == "search.extensions.threat") {
    set_boolean_option(name,search.threat_extensions,value);
  }
  else if (name == "search.late_move_reductions") {
    set_boolean_option(name,search.late_move_reductions,value);
  }
  else if (name == "search.checks_in_qsearch") {
    set_int_option(name,search.checks_in_qsearch,value);
  }
  else if (name == "search.can_resign") {
    set_boolean_option(name,search.can_resign,value);
  }
  else if (name == "search.resign_threshold") {
    set_int_option(name,search.resign_threshold,value);
  }
  else if (name == "search.hash_table_size") {
    set_int_option(name,search.hash_table_size,value);
  }
  else if (name == "search.use_tablebases") {
    set_boolean_option(name,search.use_tablebases,value);
  }
  else if (name == "search.tb_cache_size") {
    set_int_option(name,search.tb_cache_size,value);
  }
  else if (name == "search.tablebase_location") {
    search.tablebase_location = value;
  }
  else if (name == "search.ncpus") {
    set_int_option(name,search.ncpus,value);
  }
  else
    cerr << "warning: unrecognized option name: " << name << endl;
}

int Options::init(const char *fileName) {
  
  ifstream infile(fileName);
  if (!infile.good()) {
     return -1;
  }
  //cout << "Reading " << fileName << endl;
  while (infile.good() && !infile.eof()) {
    char buf[256];
    infile.getline(buf,256);    
    char *p = buf;
    while (*p && isspace(*p)) p++;
    if (*p == '#') continue;
    string name, value;
    while (*p && *p != '=') {
      name += *p++;
    }
    if (name.length()==0) continue;
    ++p;
    while(*p && !isspace(*p)) {
      value += *p++;
    }
    if (name != "")
      set_option(name,value);
  }
  return 0;
}
