// Copyright 1994 by Jon Dart.  All Rights Reserved.

#ifndef _NOTATION_H
#define _NOTATION_H

#include "chess.h"

class Board;

class Notation
{
	// This class converts our internal move representation to
	// and from standard algebraic notation.
	
public:
        static Move MoveValue( const Board &board, const char *str, const ColorType color );

	// Returns a human-readable string image of a move in "result".
	// "b" must be the board position before the move is made.
	static void Image(const Board &b, const Move &m,
		char *result );

        static void UCIMoveImage(const Move &move, char *image);

	// Parse "str", assuming it contains a move for side "color",
	// in the same string format returned by Image().  Attempts
        // to be liberal about allowing deviations from SAN.
        //
        // Returns NullMove if the string cannot be parsed or if the
        // move is ambiguous.  Note: a successful return value does not
	// necessarily mean the move is legal.
	static Move Value( const Board &b,
		const ColorType color, const char *str);
};

#endif
