#ifndef _MOVE_ARRAY_H
#define _MOVE_ARRAY_H

#include "arasvec.h"
#include <string>

using namespace std;

#include "board.h"

class MoveRecord
{
     // holds info on a move made during the game or during a search
     // operation.	      

     public:

     MoveRecord() 
     : my_move(NullMove),my_hashcode((hash_t)MAKELONGLONG(0,0))
     {
     }

     MoveRecord(const Board &board, const Board_State &previous_state,
        const Move &move, const string &image);
     // "board" is the board position after the move.
	     
     const Move &move() const
     {
 	     return my_move;
     }
     
     const hash_t hashcode() const
     {
	     return my_hashcode;
     }

     const Board_State &state() const {
         return my_state;
     }
     
     int operator == ( const MoveRecord &l ) const;
     int operator != ( const MoveRecord &l ) const;
     
     bool operator < (const MoveRecord &mr) const
     {
        return my_hashcode < mr.my_hashcode;
     }
     
     MoveRecord(const MoveRecord &r)
     : my_move(r.my_move),
       my_hashcode(r.my_hashcode),
       my_state(r.my_state),
       my_image(r.my_image)
       {
       }
       
     MoveRecord &operator = (const MoveRecord &r ) {
       if (this != &r) {
          my_move = r.my_move;
          my_hashcode = r.my_hashcode;
          my_state = r.my_state;
          my_image = r.my_image;
       }
       return *this;
     }

     const char *image () const {
       return my_image.c_str();
     }     

     
     private:
	     
     Move my_move;	    
     hash_t my_hashcode;	    
     Board_State my_state;
     string my_image;
};

class MoveArray : public ArasanVector <MoveRecord>
{
     // Maintains a list of moves made in the game so far or in
     // the search process.	     
	     
     public:	     
	
     MoveArray();
	     
     virtual ~MoveArray();

     // add a move to the Move_Array. "board" is the position after the
     // move is made.	     
     void add_move( const Board &board, const Board_State &previous_state,
      const Move &emove, const string &image );
	     
     // remove the most recently added move to the Move_Array.
     void remove_move();
	     
     // return the total number of half-moves in the game:
     unsigned num_moves() const
     {
       return (unsigned)length();
     }
     
     unsigned num_moves(const ColorType side) const;

     // return the nth move in the Move_Array.  0 <= n <= num_moves - 1.
     const Move &move( unsigned n ) const;
	
     private:
	     
};

#endif

