// Copyright 1997-2002 by Jon Dart. All Rights Reserved.a
#include "movearr.h"
#include "types.h"
#include "util.h"
#include "debug.h"

MoveRecord::MoveRecord(const Board &board, const Board_State &previous_state,
 const Move &move, const string &image)
: my_move(move),my_hashcode(board.state.hashCode),my_state(previous_state),
  my_image(image)
{
}

int MoveRecord::operator == ( const MoveRecord &l ) const
{
  return my_hashcode == l.my_hashcode;
}

int MoveRecord::operator != ( const MoveRecord &l ) const
{
  return my_hashcode != l.my_hashcode;
}

MoveArray::MoveArray() {
}

MoveArray::~MoveArray() {
}

void MoveArray::add_move( const Board &board, 
   const Board_State &previous_state, const Move &emove,
   const string &image )
{
    MoveRecord entry( board, previous_state, emove, image );
    append(entry);
}

void MoveArray::remove_move()
{
    if (length() > 0) {
       remove_last();
    }
}

const Move &MoveArray::move( unsigned n ) const
{
    ASSERT(n<num_moves());
    const MoveRecord &entry = (*this)[n];
    return entry.move();
}

unsigned MoveArray::num_moves(const ColorType side) const
{
    if (side == White)
        return num_moves() ? num_moves()/2 + 1 : 0;
    else
        return num_moves() ? (num_moves()-1)/2 : 0;
}

