// Copyright 1998, 2005 by Jon Dart. All Rights Reserved.

#include "legal.h"
#include "movegen.h"

int legal_move(const Board &board, Square start,
               Square dest)
{
   // do a little basic sanity checking:
  if (!OnBoard(start) || !OnBoard(dest) || IsEmptyPiece(board[start])) {
    cout << "fails sanity" << endl;
      return 0;
  }

   PieceType promoteTo = InvalidPiece;
   if (TypeOfPiece(board[start]) == Pawn &&
       Rank(dest,board.Side()) == 8)
      promoteTo = Queen;
   Move emove = CreateMove(board,start,dest, promoteTo);
   Move moves[Constants::MaxMoves];
   Move_Generator mg( board, NULL, 0, NullMove, 0);
   int found = 0;
   int n = mg.GenerateAllMoves(moves, 0);

   for (int i = 0; i < n; i++)
   {
      if (MovesEqual(moves[i],emove))
      {
         found++;
         break;
      }
   }
   if (!found) {
     cout << "not found" << endl;
     return 0;
   }
   else
   {
      // check for king en prise
      Board board_copy(board);
      const ColorType side = board.Side();
      board_copy.DoMove(emove);
      int val = !board_copy.any_attacks(
                                    board_copy.KingPos(side),OppositeColor(side));
     if (!val) cout << "king en prise" << endl;
     return val;
   }
}

int have_legal_moves(const Board &board)
{
   Move moves[Constants::MaxMoves];
   Move_Generator mg(board, NULL, 0, NullMove, 0);
   int n = mg.GenerateAllMoves(moves, 0);

   for (int i = 0; i < n; i++)
   {
      // check for king en prise
      Board board_copy(board);
      const ColorType side = board.Side();
      board_copy.DoMove(moves[i]);
      if( !board_copy.any_attacks(
           board_copy.KingPos(side),OppositeColor(side)))
      {
         return 1;
      }
   }
   return 0;
}

