// Copyright 1994-2008 by Jon Dart.  All Rights Reserved.

#ifndef _GLOBALS_H
#define _GLOBALS_H

// global variables

#include "types.h"
#include "movearr.h"
#include "moveord.h"
#include "log.h"
#include "options.h"
#include "book.h"
#include "posnbook.h"

#define CMD_BUF_SIZE 16384
extern char cmd_buf[CMD_BUF_SIZE];
extern int cmd_buf_count;
#include <iostream>
#ifdef _THREAD_TRACE
#include <stdio.h>
#endif

extern Book *opening_book;
extern PositionBook *position_book;
extern Log *theLog;
extern MoveArray *game_moves;
extern Options options;

#ifdef SMP
extern LockDefine(hash_lock);
#endif
extern int EGTBMenCount;

extern string derivePath(const char *fileName);
extern string derivePath(const char *base, const char *fileName);

extern void init_options(const char *programPath);

extern int init_globals(const char *pathName, 
int open_trace, int init_bitbases);

extern void delayed_init();

extern void CDECL cleanup_globals(void);

#endif

