// Copyright 1996 by Jon Dart. All Rights Reserved.
//
#ifndef __EPDREC_H__
#define __EPDREC_H__

#include "strpair.h"
#include <fstream>
#include <string>
#include <list>

using namespace std;

// This class encapsulates info about one EPD
// (Extended Position Description) record.

class EPDRecord
{
public:
    EPDRecord();
    ~EPDRecord();

    bool hasVal(const char * key) const;

    bool getVal(const char * key, string &val) const;

    void add(const char * key, const char * val);

    bool hasError() const
    {
        return err.length() > 0;
    }

    const string &getError() const
    {
        return err;
    }

    void setError(const string &anErr)
    {
        err = anErr;
    }
    
    bool getData(int i,string &key,string &val) const;
    
    int getSize() const
    {
       return (int)cmds.size();
    }
    
    void sort();
    
private:
    list<StringPair*> cmds;
    string err;
};

#endif
