// Copyright 1994 by Jon Dart
#ifndef __ECO_H__
#define __ECO_H__

#include "movearr.h"
#include "ecoinfo.h"
#include <string>
#include <map>

using namespace std;

struct compareEco
{
  bool operator()(const hash_t &key1, const hash_t &key2) const
  {
    return key1 < key2;
  }
};

class ECO
{
public:
    ECO();
    
    // Look up a game log, return its ECO code (in "result") and the
    // descriptive name of the opening (in "name"), if there is one.	    
    void classify( const MoveArray &moves, string &result, string &name);
        
private:        
    map <uint64,ECO_Info*,compareEco> ht;
};

#endif
