// Copyright 1994 by Jon Dart

#include "eco.h"
#include "ecodata.h"
#include "ecoinfo.h"

#define HASHSIZE 61

ECO::ECO()
{
// fill up hash table
   for (const eco_data *d = eco_codes; d->eco; d++)
   {
        ECO_Info *ei = new ECO_Info(d->eco, d->opening_name, d->hash_code);
        map<uint64,ECO_Info*,compareEco>::value_type p(d->hash_code,ei);
        ht.insert(p);
   }
}

void ECO::classify( const MoveArray &moves, string &result, string &name)
{
    // We take kind of a simple-minded approach to ECO classification.
    // Each ECO code is associated with a chess position.  We follow the
    // game moves until we have found the last one that leads to a
    // hash code matching an ECO position, then report that ECO code.
    // This doesn't allow for openings that eventually transpose into
    // an ECO subline (e.g. A04/01) but don't ever hit the position
    // for the main ECO code (e.g. A04) - this is possible.     
    result = "";
    name = "";
    for ( unsigned i = 0; i < moves.num_moves(); i++)
    {
        map<uint64,ECO_Info*,compareEco>::const_iterator it =
         ht.find(moves[i].hashcode());
        if (it != ht.end())
        {
   	   ECO_Info *hit = (*it).second;
  	   const char *p = hit->get_eco();
           result = "";
           result += p[0];
           result += p[1];
           result += p[2];
           // Not all ECO lines have opening names.
           if (*hit->get_opening_name())
	      name = hit->get_opening_name();
        }
    }
    //name = "";
}
