// Copyright 1998-2007 by Jon Dart.  All Rights Reserved.
#ifndef _CONFIG_H
#define _CONFIG_H

#include "chess.h"

// Various search parameters and options - these are not settable
// via arasan.rc, but are compile-time constants.

#define SEARCH_WINDOW PAWN_VALUE

// One "ply" of search extension:
static const int DEPTH_INCREMENT = 12;
#define QSEARCH_FORWARD_PRUNE_BIAS (5*PAWN_VALUE)/4
#define NEGASCOUT
// variable null depth reduction (between R=2 and R=3):
#define ADAPTIVE_NULL
#define VERIFY_NULL_SEARCH
#define FUTILITY_DEPTH DEPTH_INCREMENT
#define FUTILITY_PRUNE
#define FUTILITY_MARGIN (PAWN_VALUE*7)/4
#define EXTENDED_FUTILITY_PRUNE
#define EXTENDED_FUTILITY_DEPTH 3*DEPTH_INCREMENT
#define EXTENDED_FUTILITY_MARGIN (5*PAWN_VALUE)
#define CHECK_EXTENSION DEPTH_INCREMENT
#define FORCED_EXTENSION DEPTH_INCREMENT
#define RECAPTURE_EXTENSION (3*DEPTH_INCREMENT)/4
#define REPETITION_EXTENSION (DEPTH_INCREMENT/2)
#define PAWN_PUSH_EXTENSION DEPTH_INCREMENT
#define THREAT_EXTENSION (DEPTH_INCREMENT)/2
#define HISTORY_REDUCTION (DEPTH_INCREMENT)
//#define TWO_STAGE_WINDOW

#define MAX_CPUS 16
// min remaining search depth to do splitting
// (actually this is variable based on material)
#define THREAD_SPLIT_MIN_DEPTH 6
// max ply depth at which to do splitting
#define THREAD_SPLIT_LIMIT 3
// number of split points a single search (in one thread) can have
#define SPLIT_STACK_MAX_DEPTH 3

// Scoring options
#define USE_LAZY_EVAL

// statistics
#define EVAL_STATS
//#define MOVE_ORDER_STATS
#define SMP_STATS

#endif
