#ifndef __CHESSIO_H__
#define __CHESSIO_H__

#include "types.h"
#include "epdrec.h"
#include "board.h"
#include "strpair.h"
#include "arasvec.h"
#include "movearr.h"
#include <fstream>
#include <string>

using namespace std;

// This class handles I/O of PGN, FEN and EPD files.
// Note: some functions are only used in the GUI.
//
class ChessIO
{
public:

    // return (in descr) a single-line description of a game, based on
    // its PGN headers (for game list display).
    static void get_game_description(const ArasanVector<StringPair> &hdrs, string &descr);

    // scan a PGN file, fill "contents" with strings.  Each string contains
    // a descriptive 1-line header followed by a tab and the file offset
    // of the game in decimal digits. 
    static int scan_pgn(istream &ifs, ArasanVector<string> &contents);

    // Store a PGN file with the specified headers
    static int store_pgn(ostream &ofs, MoveArray &moves,
                         const ColorType computer_side,
                         const string &result,
	                 ArasanVector<StringPair> &headers);

    static int store_pgn(ostream &ofs, MoveArray &moves,
                         const string &result,
	                 ArasanVector<StringPair> &headers);

    static int load_fen(istream &ifs, Board &board);
    static int store_fen(ostream &ofs, const Board &board);

    // read a PGN game header from the file.
    static void collect_headers(istream &game_file, 
      ArasanVector<StringPair> &hdrs, long &first);

    // get a specific header out of a collection of headers (returned
    // from collect_headers)
    static int get_header(const ArasanVector<StringPair> &hdrs, 
	  const char * key, string &val);

    // read an EPD file
    static EPDRecord * readEPDRecord(istream &ifs, Board &board);
    
    enum Token { Number, GameMove, Result, Comment, Unknown, Ignore, Eof };

    // read the next token from the "body" of a PGN game.
    static Token get_next_token(istream &game_file, char *buf, int limit);

};

#endif
