// Copyright 1997 by Jon Dart.  All Rights Reserved
#ifndef _CALCTIME_H_
#define _CALCTIME_H_

#include "types.h"

// Calculate the recommended time to search.
// minutes = minutes per game or time period
// incr = increment in seconds
// time_left = side to move time left in seconds*100
// opp_time = opponent's time left in seconds*100
// ponder = true if pondering enabled
// trace = 1 if tracing on, 0 if off
extern int calc_time_limit(int moves, int minutes, int incr, 
      int time_left, int opp_time, int ponder, int trace);

// UCI version
extern int calc_time_limit(int movestogo, int incr, 
      int time_left, int opp_time, int ponder, int trace);

#endif
