// Copyright 1997, 1998, 1999 by Jon Dart. All Rights Reserved.
#include "calctime.h"
#include "globals.h"
#include "util.h"

// Calculate time limit for a 0-increment game
static int zero_inc_time_limit(int minutes,int time_left,int ponder)
{
   int t =  time_left/40;
   if (ponder) t += t/4;
   if (time_left > minutes*3000)
   {
      t += (time_left - minutes*3000)/50;
   }
   return t;
}

int calc_time_limit(int moves, int minutes, int incr, 
   int time_left, int opp_time, int ponder, int trace)
{
        int time_target = 0;
        int moves_in_game = game_moves->num_moves()/2; // full moves, not half-moves
        int est_time = incr/4 + minutes;
        if (incr > 0 && minutes == 0)
        {
            // Fixed time per move
            if (time_left > 400*incr)
            {
               time_target = incr*150;
            }
            else if (time_left > 250*incr)
            {
               time_target = incr*125;
            }
            else if (time_left > 125*incr)
            {
               time_target = 80*incr;
            }
            else
            {
               time_target = Util::Min(time_left/2,incr*60);
            }
        }
        else if (incr >0)
        {
            int pct_time_left = (time_left*100)/(6000*minutes);
            // Fischer-type time control

            int extra_time = (time_left - 6000*minutes);
            if (extra_time < 0) extra_time = 0;
            
            time_target = zero_inc_time_limit(est_time,time_left,ponder) 
             + (extra_time/12);
            if (trace) cout << "(debug) zero inc time = " << time_target << endl;
            if (time_left < incr*100)
            {
               time_target = 0;
            }
            else if (pct_time_left <= 25)
            {
               time_target = incr*75 + time_target;
            }
            else
               time_target = incr*90 + (3*pct_time_left*incr)/5 + time_target;
            if (trace) cout << "(debug) time after inc adj = " << time_target << endl;

            // try not to fall behind the opponent
            int threshold = time_target*4;
            if (Util::Abs(time_left-opp_time)>threshold)  {
                if (time_left > 3000) {
                   //cout << "(debug) before adjust: " << time_target << endl;
                   int max_boost;
                   if (incr < minutes/2)
                     max_boost = 100*incr + time_target/4;
                   else
                     max_boost = 100*incr + time_target/6;
                   if (opp_time > time_left + threshold) {
                       time_target -= Util::Min(max_boost,(opp_time-time_left-threshold)/20);
                       if (time_target < incr*100)
                            time_target = 90*incr;
                   }
                   else if (time_left > opp_time + threshold) {
                       time_target += Util::Min(max_boost,(time_left-opp_time-threshold)/10);
                   }
                   if (trace) cout << "(debug) after opp time adjust: " << time_target << endl;
                }
            }
        }
        else // zero-increment or "Tournament" game
        {
            if (time_left > 500)
                time_left-= 500;
            if (moves == 0) // "Game" time limit
            {
               time_target = zero_inc_time_limit(minutes,time_left,ponder);
               // try not to fall behind the opponent
               int threshold = Util::Min(9000,400*est_time);
               int max_boost = time_target/4;
               if (opp_time > time_left + threshold && time_left > 3000)
               {
                   time_target -= Util::Min(max_boost,(opp_time-time_left-threshold)/10);
               }
               else if (time_left > opp_time + threshold)
               {
                   time_target += Util::Min(max_boost,(time_left-opp_time-threshold)/10);
               }
            }
            else // tournament style, e.g. 40 moves in 40 minutes.
            {
               int moves_to_time_control = moves-(moves_in_game % moves);
               // xboard fix for last move of time control                      
               if (moves_to_time_control == 1 && time_left >= moves*minutes*100\
) {                                                                             
                  if (trace) cout << "(debug) applying xboard fix" << endl;      
                  time_left -= moves*minutes*100;                               
               }                                         
               time_target = ((time_left-200) * 99) / (moves_to_time_control * 100);  // 99% of average time
	       // can use some more time if pondering
	       if (ponder) time_target += (time_target*(Util::Min(33,moves_to_time_control*3)))/100;
               if (trace) cout << "(debug) time_target = " << time_target << endl;
            }
        }
        // set a minimum (0.3 sec).
        if (time_target < 30) time_target = 30;
        //cout << "(debug) time target = " << time_target << endl;
        if (time_target > time_left) 
        {
           if (trace) cout << "(debug) warning : time_target > time_left" << endl;
           if (incr)
              time_target = 50*incr;
           else
             time_target = time_left/4;
        }
        return time_target;
}

// UCI version
int calc_time_limit(int movestogo, int incr, 
		    int time_left, int opp_time, int ponder, int trace) {
      int time_target = time_left/40 + 100*incr;
      if (incr >0) {
         if (time_left < 400*incr) {
	   time_target /= 4;
         }
         if (time_left < 200*incr) {
	   time_target /= 4;
         }
         if (time_left < 100*incr) {
	   time_target = 0;
         }
      }
      if (movestogo > 0) {
	// "Tournament" time control
        time_target = ((time_left-200) * 99) / (movestogo * 100);  // 99% of average time
      }
      if (time_target < 30) time_target = 30;
      if (trace) cout << "(debug) time_target = " << time_target << endl;
      return time_target;
}
