// Copyright 1992, 1995 by Jon Dart.  All Rights Reserved.

#ifndef _BOOK_READER_H
#define _BOOK_READER_H

#include "bookdefs.h"
#include "bookinfo.h"
#include "board.h"
#include "pinfo.h"
#include "bookutil.h"

class Book_Reader
{
        // provides access to the opening book.

        public:

        Book_Reader(const char* fileName, const char* mappingName,
          bool create = false);
        // opens book file
                
        ~Book_Reader();
        // closes book file
                
        const bool is_open() const
        {
           return open;
        }
                
        // Set "loc" to the location of the head of the hash chain
        // for the board position.  If style is non-zero, selects moves
        // matching a particular style.
        const void head( const Board &b, Book_Location &loc);

        // Fetches the book entry from the file. "loc" is the location.
        // Reads need not be sequential.
        void fetch( const Book_Location &loc, Book_Info &book_entry );
        
        // Updates a book position with a new weight.
        void update(const Book_Location &loc, float learn_factor);
        
        // Updates a book position with a new learn value (used for
        // game result learning)
        void update(const Book_Location &loc,Book_Entry *newEntry);

        // Randomly pick a move for board position "b". "loc" is
        // the starting location, obtained from the head function.
        // "info" is filled in with information on the move chosen.
        Move pick( const Board &b, const Book_Location &loc,
          Book_Info &info);

       void syncCurrentPage();
        
       int book_moves(const Board &b, Move *moves, int *scores,  const unsigned
       limit);

       int book_move_count(hash_t hashcode);
       
       protected:
               
       const void head( hash_t hashcode, Book_Location &loc);

       Move pickRandom(const Board &b, Book_Entry * candidates,
          int * candidate_weights,
          int candidate_count,int total_weight,
          Book_Location *locs,Book_Info &info);

       FILE_HANDLE book_file;
       void *pBook;
       byte *pPage;
       MEM_HANDLE hFileMapping;
       bool open;
       int current_page;
       Book_Header hdr;
       
       private:
           
       void fetch_page(int page);
       BookUtil bu;
};

#endif
