// Copyright 1998 by Jon Dart.  All Rights Reserved.

#ifndef _BOOK_INFO_H
#define _BOOK_INFO_H

#include "types.h"
#include "bookdefs.h"
#include "bookentr.h"
#include "chess.h"

class Book_Info : public Book_Entry{

     // This class is an extension of Book_Entry. It is returned
     // when we search the book and has some information besides
     // what was in the book entry on disk.

public:

     Book_Info()
     :  Book_Entry(),
        total_moves(0),
        loc(0,0),
        m(NullMove)
     {
     }

     Book_Info( hash_t hc, byte rec, byte mv_indx,
	         int last = 0)
        : Book_Entry(hc,rec,mv_indx,last),total_moves(0),
          m(NullMove)
     {
        loc.index = INVALID;
     }

     Book_Info(const Book_Entry &be) 
       :Book_Entry(be),
       total_moves(0), 
       m(NullMove)
     {
     }

     void clear()
     {
        my_hash_code = (hash_t)0;
     }
     
     int is_valid() const
     {
        return my_hash_code != (hash_t)0;
     }
     
     int get_total_moves() const
     {
        return total_moves;
     }
     
     void set_total_moves(int moves)
     {
        total_moves = moves;
     }
     
     void get_location(Book_Location &locn) const
     {
        locn = loc;
     }
     
     void set_location(const Book_Location &locn)
     {
        loc = locn;
     }
     
     Move get_move() const
     {
        return m;
     }
     
     void set_move(const Move move)
     {
        m = move;
     }

private:
     
     int total_moves;
     Book_Location loc; // head of the hash chain
     Move m; // move selected
};

#endif
