// Copyright 1993 by Jon Dart. All Rights Reserved.

#ifndef _BOOK_ENTRY_H
#define _BOOK_ENTRY_H

#include "types.h"

class Book_Entry {
     // defines one entry in the opening book's hash table.

public:

     Book_Entry()
       :my_hash_code(0),frequency(0),move_index(0),flags(0),
        winloss(0),learn_score(0.0)
     {
     }

     Book_Entry( hash_t hc, byte rec, byte mv_indx,
	         int last = 0);

     Book_Entry(const Book_Entry &be) 
       :
       my_hash_code(be.my_hash_code),
       frequency(be.frequency),
       move_index(be.move_index),
       flags(be.flags),
       winloss(be.winloss),
       learn_score(be.learn_score),
       flags2(be.flags2)
     {
     }

     void init( hash_t hc, uint16 freq, byte flags, byte mv_indx);
 
     hash_t hash_code() const
     {
        return my_hash_code;
     }
     
     byte get_move_index() const
     { 
	return move_index;
     }
     
     int get_winloss() const
     {
        return (int)winloss;
     }
     
     void set_winloss(int w)
     {
        winloss = w;
     }
     
     uint32 get_frequency() const;
     
     void set_frequency(uint32 f);
     
     int is_last() const;

     void set_last(int b = 1);

     unsigned get_recommend() const;

     void set_basic(int b = 1);

     int is_basic() const;

     int get_learned_result()  const;

     void update_learned_result(int diff);

     int operator == (const Book_Entry &b) {
       return (my_hash_code == b.my_hash_code);
     }

     hash_t my_hash_code;
     byte frequency;
     byte move_index;
     byte flags;
     signed char winloss;
     float learn_score;
     byte flags2;
};

#endif
