// Copyright 1993-1995, 2001, 2006 by Jon Dart.  All Rights Reserved.

#include "bookentr.h"

Book_Entry::Book_Entry( hash_t hc, byte rec, byte mv_indx, 
   int last )
  : my_hash_code(hc), 
  move_index(mv_indx), flags(rec/5 + (last ? 0x80 : 0)), winloss(0), flags2(0)
{
}

void Book_Entry::init( hash_t hc, uint16 freq, byte rec, byte mv_indx)
{
  my_hash_code = hc;
  flags = rec;
  frequency = (int)freq;
  winloss = 0;
  flags2 = 0;
  move_index = mv_indx;
}

int Book_Entry::is_last() const
{
   return (flags & 0x80) != 0;
}

void Book_Entry::set_frequency(uint32 f)
{
   if (f >= 65536) {
     frequency = 255;
     flags |= 0x40;
     flags &= ~0x20;
   }
   else if (f >= 4096)
   {
      frequency = f/256;
      flags |= 0x40;
      flags &= ~0x20;
   }
   else if (f >= 256)
   {
      frequency = f/32;
      flags &= ~0x40;
      flags |= 0x20;
   }
   else
   {
      frequency = f;
      flags &= ~0x40;
      flags &= ~0x20;
   }
}

uint32 Book_Entry::get_frequency() const
{
   if (flags & 0x40)
   {
      return frequency*256;
   }
   else if (flags & 0x20)
   {
      return frequency*32;
   }
   else
     return frequency;
}


void Book_Entry::set_last(int b)
{
   if (b)
      flags |= 0x80;
   else
      flags &= ~0x80;
}

unsigned Book_Entry::get_recommend() const
{
   return 5*(unsigned)(flags & 0x1f);
}

void Book_Entry::set_basic(int b) {
  if (b) flags2 |= 0x80;
  else flags2 &= ~0x80; 
}

int Book_Entry::is_basic() const {
  return (flags2 & 0x80);
}

int Book_Entry::get_learned_result()  const {
  unsigned x = (unsigned)(flags2 & 0x7f);
  if (x & 0x40)
    return -(int)(128-x);
  else
    return (int)x;
}

void Book_Entry::update_learned_result(int diff) {
  int x = get_learned_result();
  int y = x + diff;
  if (y >= 64 || y <= -64)
    return;
  flags2 = flags2 & 0x80;
  if (y < 0)
    flags2 |= (byte)(128+y);
  else
    flags2 |= (byte)y;
}

