// Copyright 2004, 2008 Jon Dart. All Rights Reserved.
//
// This module interfaces with bitbases and other in-memory scoring
// tables.

#include "bitprobe.h"
#include "globals.h"
#include "tbprobe.h"
#include <fstream>

byte *baseKPKW;
byte *baseKPKB;

int initBitbase() {

   baseKPKW = new byte[24576];
   baseKPKB = new byte[24576];

/**   memset(baseKPKW,'\0',24576);
   memset(baseKPKB,'\0',24576);
   for (Square pawnsq = 8; pawnsq < 56; pawnsq++) {
      for (Square wsq = 0; wsq < 64; wsq++) {
         for (Square bsq = 0; bsq < 64; bsq++) {
            extern int distances[64][64];
            if (bsq == pawnsq || wsq == pawnsq || bsq == wsq) continue;
            if (distances[bsq][wsq]<=1) continue;
            Board b;
            b.makeEmpty();
            b.setContents(whitePawn,pawnsq);
            b.setContents(blackKing,bsq);
            b.setContents(whiteKing,wsq);
            b.setSide(White);
            b.setCastleStatus(Board::CantCastleEitherSide,White);
            b.setCastleStatus(Board::CantCastleEitherSide,Black);
            b.set_secondary_vars();
            int score;
            if (probe_tb(b, score, 0)) {
               if (score>0) {
                  int index = ((((pawnsq-8)<<6) | wsq)<<6)|bsq;
                  int bytei = index/8;
                  if (bytei>=24576) cout << "error" << endl;
                  ASSERT(bytei<24576);
                  baseKPKW[bytei] |= 1<<(index%8);
               }
            }
            else cout << b << endl;
            b.setSide(Black);
            if (probe_tb(b, score, 0)) {
               if (score<0) {
                  int index = ((((pawnsq-8)<<6) | wsq)<<6)|bsq;
                  int bytei = index/8;
                  if (bytei>=24576) cout << "error" << endl;
                  baseKPKB[bytei] |= 1<<(index%8);
               }
            }
            else cout << b << endl;
         }
      }
   }
   ofstream bstr(derivePath("kpk-b.bit").c_str(),ios::binary);
   ofstream wstr(derivePath("kpk-w.bit").c_str(),ios::binary);
   wstr.write((char*)baseKPKW,24576);
   bstr.write((char*)baseKPKB,24576);
   wstr.close();
   bstr.close();
   cout << "ok " << endl;**/

   string wname,bname;
   wname = derivePath("kpk-w.bit");
   bname = derivePath("kpk-b.bit");

   ifstream fw(wname.c_str(),ios::binary);
   if (!fw.good()) {
     return 0;
   }
   fw.read((char*)baseKPKW,24576);
   if (!fw.good()) {
     return 0;
   }
   ifstream fb(bname.c_str(),ios::binary);
   if (!fb.good()) {
     return 0;
   }
   fb.read((char*)baseKPKB,24576);
   if (!fb.good()) {
     return 0;
   }

   fw.close();
   fb.close();
 
   return 1;
}

int lookupBitbase(const byte *base, int index) {
   ASSERT(index<24576*8);
   return (base[index/8] & (1<<(index%8))) != 0;
}

int lookupBitbase(Square whiteK, Square whiteP, Square blackK,
   ColorType strongerSide, ColorType sideToMove) {
   if (strongerSide == White) {
      if (sideToMove == White)
        return lookupBitbase(baseKPKW,((((whiteP-8)<<6)|whiteK)<<6) | blackK);
      else
        return lookupBitbase(baseKPKB,((((whiteP-8)<<6)|whiteK)<<6) | blackK);
   }
   else {
      if (sideToMove == White)
        return lookupBitbase(baseKPKB,((((Flip[whiteP]-8)<<6)|Flip[whiteK])<<6) | Flip[blackK]);
      else
        return lookupBitbase(baseKPKW,((((Flip[whiteP]-8)<<6)|Flip[whiteK])<<6) | Flip[blackK]);
   }
}

int lookupBitbase(const Board &board) {
   const Material &wMat = board.getMaterial(White);
   const Material &bMat = board.getMaterial(Black);
   int index;
   if (wMat.material_level() > 0 || 
       bMat.material_level() > 0) return NOHIT;
   if (wMat.infobits() == Material::KP &&
       bMat.king_only()) {
     Square pawnSq = board.pawn_bits[White].first_one();
     index = (((pawnSq-8)<<6 | board.KingPos(White)) << 6) | board.KingPos(Black);
     if (board.Side() == Black)
        return lookupBitbase(baseKPKB,index);
     else
        return lookupBitbase(baseKPKW,index);
   }
   else if (bMat.infobits() == Material::KP &&
       wMat.king_only()) {
     Square pawnSq = board.pawn_bits[Black].first_one();
     index = (((Flip[pawnSq]-8)<<6 | Flip[board.KingPos(Black)]) << 6) | board.KingPos(White);
     if (board.Side() == Black)
        return lookupBitbase(baseKPKW,index);
     else
        return lookupBitbase(baseKPKB,index);
   }
   return NOHIT; // shouldn't get here
}
