// Copyright 1994, 1996, 2005 by Jon Dart
#include "bitmap.h"

static int done_init = 0;
CACHE_ALIGN DiagInfo2 DiagInfoA1[64];
CACHE_ALIGN DiagInfo2 DiagInfoA8[64];

masks all_masks[64];

const CACHE_ALIGN uint64 Bitmap::mask[64] =
{
   1,
   ((uint64)1) << 1,
   ((uint64)1) << 2,
   ((uint64)1) << 3,
   ((uint64)1) << 4,
   ((uint64)1) << 5,
   ((uint64)1) << 6,
   ((uint64)1) << 7,
   ((uint64)1) << 8,
   ((uint64)1) << 9,
   ((uint64)1) << 10,
   ((uint64)1) << 11,
   ((uint64)1) << 12,
   ((uint64)1) << 13,
   ((uint64)1) << 14,
   ((uint64)1) << 15,
   ((uint64)1) << 16,
   ((uint64)1) << 17,
   ((uint64)1) << 18,
   ((uint64)1) << 19,
   ((uint64)1) << 20,
   ((uint64)1) << 21,
   ((uint64)1) << 22,
   ((uint64)1) << 23,
   ((uint64)1) << 24,
   ((uint64)1) << 25,
   ((uint64)1) << 26,
   ((uint64)1) << 27,
   ((uint64)1) << 28,
   ((uint64)1) << 29,
   ((uint64)1) << 30,
   ((uint64)1) << 31,
   ((uint64)1) << 32,
   ((uint64)1) << 33,
   ((uint64)1) << 34,
   ((uint64)1) << 35,
   ((uint64)1) << 36,
   ((uint64)1) << 37,
   ((uint64)1) << 38,
   ((uint64)1) << 39,
   ((uint64)1) << 40,
   ((uint64)1) << 41,
   ((uint64)1) << 42,
   ((uint64)1) << 43,
   ((uint64)1) << 44,
   ((uint64)1) << 45,
   ((uint64)1) << 46,
   ((uint64)1) << 47,
   ((uint64)1) << 48,
   ((uint64)1) << 49,
   ((uint64)1) << 50,
   ((uint64)1) << 51,
   ((uint64)1) << 52,
   ((uint64)1) << 53,
   ((uint64)1) << 54,
   ((uint64)1) << 55,
   ((uint64)1) << 56,
   ((uint64)1) << 57,
   ((uint64)1) << 58,
   ((uint64)1) << 59,
   ((uint64)1) << 60,
   ((uint64)1) << 61,
   ((uint64)1) << 62,
   ((uint64)1) << 63
};

int Bitmap::R90[64] =
{
   56,48,40,32,24,16,8,0,
   57,49,41,33,25,17,9,1,
   58,50,42,34,26,18,10,2,
   59,51,43,35,27,19,11,3,
   60,52,44,36,28,20,12,4,
   61,53,45,37,29,21,13,5,
   62,54,46,38,30,22,14,6,
   63,55,47,39,31,23,15,7
};

int Bitmap::unrot90[64] =
{
   7,15,23,31,39,47,55,63,
   6,14,22,30,38,46,54,62,
   5,13,21,29,37,45,53,61,
   4,12,20,28,36,44,52,60,
   3,11,19,27,35,43,51,59,
   2,10,18,26,34,42,50,58,
   1,9,17,25,33,41,49,57,
   0,8,16,24,32,40,48,56
};


int Bitmap::da1[64]=
{
   0,8,16,24,32,40,48,56,
   9,17,25,33,41,49,57,1,
   18,26,34,42,50,58,2,10,
   27,35,43,51,59,3,11,19,
   36,44,52,60,4,12,20,28,
   45,53,61,5,13,21,29,37,
   54,62,6,14,22,30,38,46,
   63,7,15,23,31,39,47,55
};

int Bitmap::unrot_da1[64] =
{
   0,15,22,29,36,43,50,57,
   1,8,23,30,37,44,51,58,
   2,9,16,31,38,45,52,59,
   3,10,17,24,39,46,53,60,
   4,11,18,25,32,47,54,61,
   5,12,19,26,33,40,55,62,
   6,13,20,27,34,41,48,63,
   7,14,21,28,35,42,49,56
};

int Bitmap::MagicTable32[32];
#if defined(_64BIT)
int Bitmap::MagicTable64[64];
#endif

int Bitmap::da1mod8[64];
int Bitmap::da8mod8[64];
int Bitmap::da1div8[64];
int Bitmap::da8div8[64];

int Bitmap::da1_mask[64] =
{
   1,0x3,0x7,0xf,0x1f,0x3f,0x7f,0xff,
   0x3,0x7,0xf,0x1f,0x3f,0x7f,0xff,0xfe,
   0x7,0xf,0x1f,0x3f,0x7f,0xff,0xfe,0xfc,
   0xf,0x1f,0x3f,0x7f,0xff,0xfe,0xfc,0xf8,
   0x1f,0x3f,0x7f,0xff,0xfe,0xfc,0xf8,0xf0,
   0x3f,0x7f,0xff,0xfe,0xfc,0xf8,0xf0,0xe0,
   0x7f,0xff,0xfe,0xfc,0xf8,0xf0,0xe0,0xc0,
   0xff,0xfe,0xfc,0xf8,0xf0,0xe0,0xc0,0x80
};

int Bitmap::da8[64] =
{
   56, 48, 40, 32, 24, 16, 8, 0,
   1,  57, 49, 41, 33, 25, 17,9,
   10, 2,  58, 50, 42, 34, 26, 18,
   19, 11, 3,  59, 51, 43, 35, 27,   
   28, 20, 12, 4,  60, 52, 44, 36,
   37, 29, 21, 13, 5,  61, 53, 45,
   46, 38, 30, 22, 14, 6,  62, 54,
   55, 47, 39, 31, 23, 15, 7,  63
};

int Bitmap::unrot_da8[64] =
{
   7,8,17,26,35,44,53,62,
   6,15,16,25,34,43,52,61,
   5,14,23,24,33,42,51,60,
   4,13,22,31,32,41,50,59,
   3,12,21,30,39,40,49,58,
   2,11,20,29,38,47,48,57,
   1,10,19,28,37,46,55,56,
   0,9,18,27,36,45,54,63
};

int Bitmap::da8_mask[64] =
{
   0xff,0x7f,0x3f,0x1f,0xf,0x7,0x3,1,
   0xfe,0xff,0x7f,0x3f,0x1f,0xf,0x7,0x3,
   0xfc,0xfe,0xff,0x7f,0x3f,0x1f,0xf,0x7,
   0xf8,0xfc,0xfe,0xff,0x7f,0x3f,0x1f,0xf,
   0xf0,0xf8,0xfc,0xfe,0xff,0x7f,0x3f,0x1f,
   0xe0,0xf0,0xf8,0xfc,0xfe,0xff,0x7f,0x3f,
   0xc0,0xe0,0xf0,0xf8,0xfc,0xfe,0xff,0x7f,
   0x80,0xc0,0xe0,0xf0,0xf8,0xfc,0xfe,0xff
};

void Bitmap::init()
{
   int i;
   for (i = 0; i < 64; i++)
   {
      all_masks[i].mask = mask[i];
      all_masks[i].not_mask = ~mask[i];
      all_masks[i].maskR90 = mask[R90[i]];
      all_masks[i].not_maskR90 = ~all_masks[i].maskR90;
      all_masks[i].maskDa1 = mask[da1[i]];
      all_masks[i].not_maskDa1 = ~all_masks[i].maskDa1;
      all_masks[i].maskDa8 = mask[da8[i]];
      all_masks[i].not_maskDa8 = ~all_masks[i].maskDa8;
      da1mod8[i] = da1[i] % 8;
      da8mod8[i] = da8[i] % 8;
      da1div8[i] = da1[i] >> 3;
      da8div8[i] = da8[i] >> 3;
   }
#if defined(_64BIT)
   for (i=0;i<64;i++) {
     int64 bits = (int64)(((uint64)1)<<i);
     int index = (int)((GETBIT64(bits)*MAGIC64)>>58);
     MagicTable64[index] = i;
   }
#else
   for (i=0;i<32;i++) {
     unsigned bits = (((unsigned)1)<<i);
     int index = (int)((GETBIT32(bits)*MAGIC32)>>27);
     MagicTable32[index] = i;
   }
#endif
   done_init++;
}

void Bitmap::cleanup()
{
}
                                   
ostream & operator << (ostream &o, const Bitmap &b)
{
   o << (hex) << b.hivalue() << b.lovalue() << (dec);
   return o;
}


